﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "Demo1IrSensorModeState.h"

namespace {
class ImageProperties
{
public:
    ImageProperties(
        int width,
        int height,
        int size,
        int workBufferSize,
        const char* pName,
        int64_t waitTime) NN_NOEXCEPT
        : m_Width(width)
        , m_Height(height)
        , m_Size(size)
        , m_WorkBufferSize(workBufferSize)
        , m_pName(pName)
        , m_WaitTimeMilli(waitTime)
    {}

    int         GetWidth() NN_NOEXCEPT  { return m_Width; }
    int         GetHeight() NN_NOEXCEPT  { return m_Height; }
    int         GetSize() NN_NOEXCEPT  { return m_Size; }
    int         GetWorkBufferSize() NN_NOEXCEPT  { return m_WorkBufferSize; }
    const char* GetName() NN_NOEXCEPT  { return m_pName; }
    int64_t     GetWaitTimeMilli() NN_NOEXCEPT { return m_WaitTimeMilli; }

private:
    int         m_Width;
    int         m_Height;
    int         m_Size;
    int         m_WorkBufferSize;
    const char* m_pName;
    int64_t     m_WaitTimeMilli;
};
}
class ImageTransferModeState : public IrSensorModeState
{
public:
    NN_STATIC_ASSERT(
        nn::irsensor::ImageTransferProcessorWorkBufferSize320x240 % nn::os::MemoryPageSize == 0
    );
    static const size_t WorkMemorySize = nn::irsensor::ImageTransferProcessorWorkBufferSize320x240 +
        nn::irsensor::ImageTransferProcessorImageSize320x240;
    static const size_t WorkMemoryAlignement = nn::os::MemoryPageSize;

    ImageTransferModeState(
        IrSensorMode* pNextProcessor,
        int* pMenuSelection,
        nn::irsensor::IrCameraHandle irCameraHandle,
        void* pWorkMemory,
        GraphicsSystem* pGraphicsSystem) NN_NOEXCEPT;
    virtual ~ImageTransferModeState() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render(
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer,
        int index) NN_NOEXCEPT NN_OVERRIDE;

private:
    void CopyImageBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;
    void RenderImageTransferProcessorState(
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer,
        const int screenIndex) NN_NOEXCEPT;
    void GetBufferToImage(const nn::gfx::Buffer* pBuffer,
        void* copyBuffer,
        nn::irsensor::ImageTransferProcessorFormat format,
        nn::irsensor::ImageTransferProcessorState* pImageTransferProcessorState,
        const nn::irsensor::IrCameraHandle& handle) const NN_NOEXCEPT;

private:
    nn::irsensor::ImageTransferProcessorFormat m_Format;
    nn::irsensor::ImageTransferProcessorState m_ImageTransferProcessorState;
    nn::irsensor::ImageTransferProcessorConfig m_ImageTransferProcessorConfig;
    void* m_pImageTransferWorkBuffer;
    void* m_pImageCopyWorkBuffer;

    Texture m_Textures[3];
    Sampler m_Sampler;
    nn::gfx::Buffer m_Buffer;
    ReadWriteBase* m_pFormat;

    GraphicsSystem* m_pGraphicsSystem;
    ImageProperties* m_pProperties[3];
};
