﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdint>

#include "Mp4BoxHeaderReader.h"
#include "Mp4BoxStsdReader.h"

Mp4BoxStsdReader::Mp4BoxStsdReader(void* buffer, size_t size)
    : m_BitStreamReader(buffer, size)
    , m_SampleRate(0)
    , m_ChannelCount(0)
{
    auto p = reinterpret_cast<uint8_t*>(buffer);
    p += 1;  // version
    p += 3;  // flags
    auto entry_count = 0;
    for (auto i = 0; i < 4; ++i)
    {
        entry_count = (entry_count << 8) | *p++;
    }
    for (int entry = 0; entry < entry_count; ++entry)
    {
        Mp4BoxHeaderReader header(p, 8);
//         NNS_LOG("%s: %d\n", header.GetType().c_str(), header.GetSize());
        if (header.GetType() == "mp4a")
        {
            auto mp4a = p + 8;
            mp4a += 8;  //
            mp4a += 8;  // reserved
            for (auto i = 0; i < 2; ++i)
            {
                m_ChannelCount = (m_ChannelCount << 8) | *mp4a++;
            }
            mp4a += 2;  // samplesize
            mp4a += 2;  // pre_defined
            mp4a += 2;  // reserved
            for (auto i = 0; i < 2; ++i)
            {
                m_SampleRate = (m_SampleRate << 8) | *mp4a++;
            }
            mp4a += 2;  //
        }
        p += header.GetSize();
    }
}

int Mp4BoxStsdReader::GetSampleRate() const
{
    return m_SampleRate;
}

int Mp4BoxStsdReader::GetChannelCount() const
{
    return m_ChannelCount;
}
