﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>

#include "BitStreamReader.h"

BitStreamReader::BitStreamReader(void* pBitStream, size_t size)
    : m_pBitStream(reinterpret_cast<uint8_t*>(pBitStream))
    , m_Size(size)
    , m_BitOffset(0)
    , m_ByteOffset(0)
{
}

uint32_t BitStreamReader::Read(int bitCount)
{
    uint32_t ret = 0;
    while (bitCount > 0)
    {
        NN_ASSERT(static_cast<size_t>(m_ByteOffset) < m_Size);
        auto tmp = m_pBitStream[m_ByteOffset];
        if (bitCount <= (8 - m_BitOffset))
        {
            ret = (ret << bitCount) | ((tmp >> (8 - m_BitOffset - bitCount)) & ((1 << bitCount) - 1));
            m_BitOffset += bitCount;
            bitCount = 0;
            if (m_BitOffset == 8)
            {
                m_BitOffset = 0;
                ++m_ByteOffset;
            }
        }
        else
        {
            ret = (ret << (8 - m_BitOffset)) | (tmp & ((1 << (8 - m_BitOffset)) - 1));
            bitCount -= (8 - m_BitOffset);
            m_BitOffset = 0;
            ++m_ByteOffset;
        }
    }
    return ret;
}

int BitStreamReader::GetReadByteCount() const
{
    return m_ByteOffset + (m_BitOffset == 0 ? 0 : 1);
}
