﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @page BtmGamepadPairing Gamepad の探索とペアリング
    @tableofcontents

    @brief
    Gamepad をペアリングするためのサンプルプログラムの解説です。

    @section BtmGamepadPairing_SectionDetail 解説
    サンプルプログラムの全体像は以下の通りです。
    - Gamepad の探索
    - Gamepad の探索の中止
    - 探索中に Gamepad の sync を長押しするとペアリングが始まります
 */

#include <cstdlib>
#include <cstdio>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_TickTypes.h>

#include <nn/btm/system/btm_SystemApi.h>

namespace
{
    const char ProgramName[] = "BtmGamepadPairing Sample Application";

} // anonymous-namespace


extern "C" void nnMain()
{
    NN_LOG("%s Start.\n", ProgramName);

    nn::Result result;
    uint32_t waitCount = 0;
    uint32_t testLoop = 0;

    srand(nn::os::GetSystemTick().ToTimeSpan().GetNanoSeconds());

    while (testLoop < 100)
    {
        if (waitCount == 0)
        {
            NN_LOG("@@@ Canceling GamepadPairing\n");
            nn::btm::system::CancelGamepadPairing();

            waitCount = (rand() % 3000) + 100;
            testLoop++;
            NN_LOG("@@@ (%02d) GamepadPairing for %d sec started\n", testLoop, waitCount * 16 / 1000);
            result = nn::btm::system::StartGamepadPairing();
            NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(16));
        --waitCount;
    }

    nn::btm::system::CancelGamepadPairing();

    NN_LOG("%s Done\n", ProgramName);
}

