﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>
#include <nn/bluetooth/bluetooth_Result.public.h>
#include <nn/bluetooth/bluetooth_Result.private.h>

class myBtClient : public bluetoothClient
{
    public:


    private:

    void EventFromConnectionStateCallback(const nn::bluetooth::InfoFromConnectionStateCallback* pInfo)
    {
        bluetoothClient::EventFromConnectionStateCallback(pInfo);

        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            //setTsi(pInfo->bluetoothAddress, 10);
        }
    }

    void EventFromGetReportDataCallback(const nn::bluetooth::InfoFromGetReportCallback* pInfo)
    {
        (void)pInfo;
    }

};


static myBtClient client;


//-----------------------------------------------------------------------------
void waitLoop(int count)
{
    while(count > 0)
    {
        NN_LOG("%d..", count--);
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000));
    }
    NN_LOG("0\n");
}

//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("TBFC_CLIENT NOW RUNNING \n");

    nn::Result result;
    int waitTime = 0;
    const int MAX_WAIT_TIME = 10000;
    const int FAIL_WAIT_TIME = 5500;
    const int NORMAL_WAIT_TIME = 4000;

    client.startBluetooth();

    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

    NN_LOG("\t[Start Discovery]\n");
    nn::bluetooth::StartDiscovery();
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(15000));

    for(int k=0; k<5; k++)
    {
        nn::bluetooth::ExtSetVisibility(false, true);
        while (!client.controllerInfo[0].valid || client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            NN_LOG("\t*Please connect a (R) Joy-con\n");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));
        }

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Test Iteration %d\n", k);

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("\t\t\tUPDATING TEST PARAMETERS\n");

        result = nn::bluetooth::ExtSetVisibility(false, true);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetVisibility returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }

        result = nn::bluetooth::ExtSetTbfcScan(true);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetTbfcScan returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }
        NN_LOG("\t[PAGE SCAN ENABLED | TBFC SCAN ENABLED]\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < NORMAL_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime < NORMAL_WAIT_TIME) {
            NN_LOG("\t[PASS] Controller connected in %d ms\n\n", waitTime);
        } else {
            NN_LOG("\t[FAIL] Failed to connect in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller connected in under 4 seconds from Home button press\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press any button EXCEPT the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < NORMAL_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime < NORMAL_WAIT_TIME) {
            NN_LOG("\t[PASS] Controller connected in %d ms\n\n", waitTime);
        } else {
            NN_LOG("\t[FAIL] Failed to connect in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller connected in under 4 seconds from button press\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("\t\t\tUPDATING TEST PARAMETERS\n");

        result = nn::bluetooth::ExtSetVisibility(false, true);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetVisibility returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }

        result = nn::bluetooth::ExtSetTbfcScan(false);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetTbfcScan returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }
        NN_LOG("\t[PAGE SCAN ENABLED | TBFC SCAN DISABLED]\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < MAX_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime > NORMAL_WAIT_TIME) {
            NN_LOG("\t[PASS] Controller connected in %d ms\n\n", waitTime);
        } else {
            NN_LOG("\t[FAIL] Controller connected in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller took over 4 seconds to connect from Home button press\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press any button EXCEPT the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < NORMAL_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime < NORMAL_WAIT_TIME) {
            NN_LOG("\t[PASS] Controller connected in %d ms\n\n", waitTime);
        } else {
            NN_LOG("\t[FAIL] Failed to connect in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller connected in under 4 seconds from button press\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));


        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("\t\t\tUPDATING TEST PARAMETERS\n");

        result = nn::bluetooth::ExtSetVisibility(false, false);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetVisibility returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }

        result = nn::bluetooth::ExtSetTbfcScan(true);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetTbfcScan returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }
        NN_LOG("\t[PAGE SCAN DISABLED | TBFC SCAN ENABLED]\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < NORMAL_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime < NORMAL_WAIT_TIME) {
            NN_LOG("\t[PASS] Controller connected in %d ms\n\n", waitTime);
        } else {
            NN_LOG("\t[FAIL] Failed to connect in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller connected in under 4 seconds from Home button press\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press any button EXCEPT the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < MAX_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime >= FAIL_WAIT_TIME) {
            NN_LOG("\t[PASS] Controller failed to connect\n\n");
        } else {
            NN_LOG("\t[FAIL] Controller connected in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller failed to connect in ~5 seconds (lights on controller stopped)\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("\t\t\tUPDATING TEST PARAMETERS\n");

        result = nn::bluetooth::ExtSetVisibility(false, false);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetVisibility returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }

        result = nn::bluetooth::ExtSetTbfcScan(false);
        if (result.IsFailure()) {
            NN_LOG("\t[FAIL] ExtSetTbfcScan returned %d\n", result.GetDescription());
            NN_LOG("TEST FAILED.\n");
            break;
        }
        NN_LOG("\t[PAGE SCAN DISABLED | TBFC SCAN DISABLED]\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < MAX_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            NN_LOG("\t[PASS] Controller failed to connect\n\n");
        } else {
            NN_LOG("\t[FAIL] Controller connected in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller failed to connect in under ~10 seconds (lights on controller stopped)\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));

        NN_LOG("-----------------------------------------------------------------------\n");
        NN_LOG("\t*Press any button EXCEPT the Home button to re-connect the controller in ");
        waitLoop(5);
        waitTime = 0;
        while (waitTime < MAX_WAIT_TIME && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            NN_LOG("\t[PASS] Controller failed to connect\n\n");
        } else {
            NN_LOG("\t[FAIL] Controller connected in %d ms\n\n", waitTime);
            break;
        }
        NN_LOG("\t*Verify the controller failed to connect in ~5 seconds (lights on controller stopped)\n");

        NN_LOG("\nTest Iteration %d Complete\n", k);
        NN_LOG("-----------------------------------------------------------------------\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5000));
    }

    NN_LOG("EXITING TEST.\n");

    nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000));
    client.finishBluetooth();
} // NOLINT(impl/function_size)



