﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>

enum {DISCOVERY_INTERVAL_MS = 0}; // 0 for continuous discovery

class myBtClient : public bluetoothClient
{
public:

    int  goalTsi = 10;


private:

    void EventFromDiscoveryStateChangedCallback( const nn::bluetooth::InfoFromDiscoveryStateChangedCallback* pInfo)
    {
        bluetoothClient::EventFromDiscoveryStateChangedCallback(pInfo);
        if (DISCOVERY_INTERVAL_MS == 0 && pInfo->state == nn::bluetooth::BT_DISCOVERY_STOPPED && bondingState == NOT_BONDING)
        {
            NN_LOG("  [StartDiscovery]\n");
            nn::bluetooth::StartDiscovery();
        }
    }

    void EventFromConnectionStateCallback(const nn::bluetooth::InfoFromConnectionStateCallback* pInfo)
    {
        bluetoothClient::EventFromConnectionStateCallback(pInfo);

        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            setTsi(pInfo->bluetoothAddress, goalTsi);
            // NN_LOG("[SetZeroRetran]\n");
            // uint8_t reportIds[] = { 0x10, 0x11, 0x12, 0x13 };
            // uint8_t numReportIds = sizeof(reportIds);
            // nn::bluetooth::ExtSetZeroRetran(&pInfo->bluetoothAddress, numReportIds, reportIds);
        }
    }

    void EventFromBondStateChangedCallback( const nn::bluetooth::InfoFromBondStateChangedCallback* pInfo)
    {
        bluetoothClient::EventFromBondStateChangedCallback(pInfo);
        if (bondingState == NOT_BONDING)
        {
            NN_LOG("  [StartDiscovery]\n");
            nn::bluetooth::StartDiscovery();
        }
    }

    void EventFromExtensionCallbacks(const nn::bluetooth::InfoFromExtensionCallbacks* pInfo)
    {
        bluetoothClient::EventFromExtensionCallbacks(pInfo);

#if 0
        // SEND HID DATA
        if(pInfo->eventType==nn::bluetooth::EventFromTsiSetCallback)
        {
            //TSI# is changed.
            //Send the HID command.
            nn::bluetooth::HidData hidData;
            memset(&hidData, 0, sizeof(hidData));
            hidData.length=49;
            hidData.data[0]=0x01;
            hidData.data[10]=0x02;
            NN_LOG("  [HidSendData] %s\n", toHexString(pInfo->bluetoothAddress));
            nn::bluetooth::HidSendData(&pInfo->bluetoothAddress, &hidData);
        }
#elif 0
// KEEP CHANGING TSI CONTINUOUSLY
        if (pInfo->eventType==nn::bluetooth::EventFromTsiSetCallback)
        {
            setTsi(pInfo->bluetoothAddress, 0xFF);
        }
        else if(pInfo->eventType==nn::bluetooth::EventFromTsiExitCallback)
        {
            //int tsi_number = 8;
            int tsi_number = (rand()>>4) % 11;
            setTsi(pInfo->bluetoothAddress, tsi_number);
        }
#elif 0
// TRY SENDING ZERO RE-TRAN COMMAND
        if(pInfo->eventType==nn::bluetooth::EventFromTsiSetCallback)
        {
            uint8_t reportIds[] = { 5, 4, 3, 2 };
            NN_LOG("  [ExtSetZeroRetran] %s\n", toHexString(pInfo->bluetoothAddress));
            nn::bluetooth::ExtSetZeroRetran(&pInfo->bluetoothAddress, sizeof(reportIds), reportIds);
        }
#elif 0
// TRY SENDING MC MODE COMMAND
        if(pInfo->eventType==nn::bluetooth::EventFromTsiSetCallback)
        {
            static int i; i++;
            bool enable = (i >> 1) & 0x1; // toggle every other time
            bool wifi = 0;
            NN_LOG("  [ExtSetMcMode] en=%d wifi=%d\n", enable, wifi);
            nn::bluetooth::ExtSetMcMode(enable, wifi);
        }
#endif
    }
};


static myBtClient client;


//-----------------------------------------------------------------------------
int randomInRange(int min, int max)
{
    return ( (rand()>>4) % (max + 1 - min) ) + min;
}


//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("myBtClient NOW RUNNING \n");

    if (client.startBluetooth() < 0)
    {
        NN_LOG("Couldn't start bluetooth!\n");
        exit(-1);
    }

    int loopTimeMs=0;

    //bool enable = 0;
    //bool wifi = 0;
    //NN_LOG("  [ExtSetMcMode] en=%d wifi=%d\n", enable, wifi);
    //nn::bluetooth::ExtSetMcMode(enable, wifi);

    if (DISCOVERY_INTERVAL_MS == 0)
    {
        NN_LOG("  [StartDiscovery]\n");
        nn::bluetooth::StartDiscovery();
    }

    // try pairing every 30 seconds for 5 minutes, then try to stop Bluetooth
    while (1) //(loopTimeMs < 5*60*1000)
    {
        if ((loopTimeMs % 1000) == 0)
            client.printControllerHidCount();

// For test, disconnect/recconnect after bonding to move controller to superpiconet
#if 0
        static int jjj = 1;
        if (jjj &&
                client.controllerInfo[0].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED &&
                client.controllerInfo[0].valid)
        {
            //nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
            nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
            while (client.controllerInfo[0].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
                nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
            nn::bluetooth::HidWakeController(&client.controllerInfo[0].bdAddr);
            jjj = 0;
        }
#endif

#if 0
        // TEST TIME TO DISCONNECT ALL CONTROLLERS
        if ((loopTimeMs % 30000) == 0)
        {
            int64_t t1, t2;
            t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();

            for (int i=0; i<bluetoothClient::MAX_CTRL; i++)
            {
                if (client.controllerInfo[i].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED
                        && client.controllerInfo[i].valid)
                {
                    nn::bluetooth::HidDisconnect(&client.controllerInfo[i].bdAddr);
                }
            }

            for (bool done=0; !done; )
            {
                done = true;
                for (int i=0; i<bluetoothClient::MAX_CTRL; i++)
                {
                    if (client.controllerInfo[i].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED
                            && client.controllerInfo[i].valid)
                    {
                        done = false;
                        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5));
                        break;
                    }
                }
            }

            t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
            NN_LOG("\tDisconnect finished after %lld ms\n", t2 - t1);
        }
#elif 0
        // TEST CHANGING TSI, EVERY 5 SECONDS
        if ((loopTimeMs % 5000) == 0)
        {
            // Set sniff-mode connected controllers to active mode.
            int connectedControllers = 0;
            for (int i=0; i<bluetoothClient::MAX_CTRL; i++)
            {
                if (client.controllerInfo[i].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED
                        && client.controllerInfo[i].valid
                        && client.controllerInfo[i].tsi != 0xFF
                        && client.controllerInfo[i].tsiChangeAcked)
                {
                    client.setTsi(client.controllerInfo[i].bdAddr, 0xFF);
                    connectedControllers++;
                }
            }

            // Set new target TSI
            if      (connectedControllers > 6) client.goalTsi = randomInRange(9,10);
            else if (connectedControllers > 4) client.goalTsi = randomInRange(7,10);
            else if (connectedControllers > 2) client.goalTsi = randomInRange(1,10);
            else                               client.goalTsi = randomInRange(0,10);

        }

        // Set active-mode connected controllers to sniff mode.
        for (int i=0; i<bluetoothClient::MAX_CTRL; i++)
        {
            if (client.controllerInfo[i].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED
                    && client.controllerInfo[i].valid
                    && client.controllerInfo[i].tsi == 0xFF
                    && client.controllerInfo[i].tsiChangeAcked)
            {
                client.setTsi(client.controllerInfo[i].bdAddr, client.goalTsi);
            }
        }
#elif 0
        // FOR SAKYO (LEFT) EP1 ONLY, CHANGE THE CONTROLLER TYPE IN THE CONTROLLER FLASH
        // SEE ALSO SIGLONTD-6045.
        if (client.controllerInfo[0].valid &&
             client.controllerInfo[0].connectState == nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            NN_LOG("SENDING MSG 5..");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
            NN_LOG("4..");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
            NN_LOG("3..");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
            NN_LOG("2..");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
            NN_LOG("1..\n");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));

            nn::bluetooth::HidData hidData;
            memset(&hidData, 0, sizeof(hidData));
            hidData.length=17;
            hidData.data[0]=0x01;
            hidData.data[10]=0x11;
            hidData.data[11]=0x12;
            hidData.data[12]=0x60;
            hidData.data[15]=0x01;
            hidData.data[16]=0x01;
            NN_LOG("  [HidSendData] %s\n", client.toHexString(client.controllerInfo[0].bdAddr));
            nn::bluetooth::HidSendData(&client.controllerInfo[0].bdAddr, &hidData);

            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(3000));
        }
#elif 0
        // TEST CODE TO TRY REMOVING A BOND
        if ((loopTimeMs % 30000) == 0)
        {
            if (client.controllerInfo[0].valid)
            {
            // try to disconnect and remove the bond for the recently connected device,
                NN_LOG("  [HidDisconnect] %s\n", client.toHexString(client.controllerInfo[0].bdAddr));
                nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);

                NN_LOG("  [RemoveBond] %s\n", client.toHexString(client.controllerInfo[0].bdAddr));
                nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
                nn::bluetooth::RemoveBond(&client.controllerInfo[0].bdAddr);
                client.controllerInfo[0].valid = false;
            }
        }
#endif


#if 0
        // TEST CODE TO TRY PAIRING/REMOVE BOND MULTIPLE TIMES
        if (loopTimeMs == 0)
        {
            nn::settings::system::BluetoothDevicesSettings settings[nn::settings::system::BluetoothDevicesSettingsCountMax];
            int num = nn::settings::system::GetBluetoothDevicesSettings(settings, nn::settings::system::BluetoothDevicesSettingsCountMax);
            NN_LOG("Paired Bluetooth devices: %d\n", num);

            if (num > 0)
            {
                NN_LOG("    BD_ADDR: %s\n", client.toHexString(6, settings[0].bd_addr));
                NN_LOG("    Name: %s\n", settings[0].device_name);
                NN_LOG("-- ------------------- --\n");

                uint8_t dummyNumber = settings[0].bd_addr[5];

                for (int i=0; i<20; i++)
                {
                    nn::Result result;
                    NN_LOG("@@@ RemoveBond %s\n", client.toHexString(6, settings[0].bd_addr));
                    nn::bluetooth::BluetoothAddress removeAddr;
                    memcpy(removeAddr.address, settings[0].bd_addr, 6);
                    result = nn::bluetooth::RemoveBond(&removeAddr);
                    if (result.IsFailure())
                    {
                        NN_LOG("result = %08X\n", result.GetInnerValueForDebug());
                    }
                    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(500));
                    settings[0].bd_addr[5] = ++dummyNumber;
                    NN_LOG("@@@ AddPairedDevice %s\n", client.toHexString(6, settings[0].bd_addr));
                    result = nn::bluetooth::HidAddPairedDevice(&settings[0]);
                    if (result.IsFailure())
                    {
                        NN_LOG("result = %08X\n", result.GetInnerValueForDebug());
                    }
                    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(500));
                }
            }
        }
#endif

        if (DISCOVERY_INTERVAL_MS != 0)
        {
            // PERIODICALLY, START DISCOVERY
            if ((loopTimeMs % DISCOVERY_INTERVAL_MS) == 0)
            {
                //Discovery
                static int i = 0;
                i++;
                NN_LOG("  [StartDiscovery %d]\n", i);
                nn::bluetooth::StartDiscovery();
            }
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
        loopTimeMs += 100;
    }

    NN_LOG("  [Exiting...]\n");
    client.finishBluetooth();
} // NOLINT(impl/function_size)



