﻿
cd $Args[0]

foreach( $file in Get-ChildItem -Name *.cpp )
{
    #  $file の cpp ファイルを vcmd 用の変換します
    #  $out に一時的にソースを書き出し、後で $file に上書きして実現します
    $out = "$file" + ".tmp"
    
    $vcmdProcFlag = $FALSE

    foreach( $ln in Get-Content $file )
    {
        if( $vcmdProcFlag )
        {
            #  すでに vcmd 用の処理が書かれているならば無視します
            if( $ln -ne "#if defined(NN_ATK_CONFIG_ENABLE_VOICE_COMMAND)" )
            {
                echo "#if defined(NN_ATK_CONFIG_ENABLE_VOICE_COMMAND)" >> $out
                echo "nn::atk::SoundSystem::VoiceCommandProcess(4);" >> $out
                echo "#endif" >> $out
            }
            $vcmdProcFlag = $FALSE
        }


        echo $ln >> $out


        #  SoundArchivePlayer::Update() が呼ばれた後に
        #  VoiceCommandProcess() を呼ぶようにします
        #
        #  SoundArchivePlayer のインスタンスは
        #  "*SoundArchivePlayer" という名前になるとメタ読みしてマッチングします
        if( $ln -match "SoundArchivePlayer.Update\(\);$" )
        {
            $vcmdProcFlag = $TRUE
        }
    }

    #  ファイルに変更がなければ上書きしません
    echo n | comp "$file" "$out"
    if( "$?" -ne "true" )
    {
        Get-Content $out | Set-Content -Encoding UTF8 $file
    }
    rm $out
}
