﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../AtkSandboxCommon.h"
#include "ICheckModule.h"

class FilterCheckModule : public ICheckModule
{
private:
    enum SampleRateType
    {
        SampleRateType_32000,
        SampleRateType_48000,
        SampleRateType_Max = SampleRateType_48000
    };

public:
    virtual void OnInitializeAtk() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnFinalizeAtk() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoadData() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnPrintUsage() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateInput() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateAtk() NN_NOEXCEPT NN_OVERRIDE;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    virtual void OnUpdateDraw() NN_NOEXCEPT NN_OVERRIDE;
#endif

    virtual const char* GetModuleName() const NN_NOEXCEPT NN_OVERRIDE
    {
        return "Filter";
    }

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT NN_OVERRIDE;

private:
    // サンプルレート
    void SetSampleRateType(SampleRateType sampleRateType) NN_NOEXCEPT;
    void ReinitializeAtk() NN_NOEXCEPT;
    int  ConvertSampleRateTypeToInt(SampleRateType sampleRateType) NN_NOEXCEPT;

    // フィルタ
    void SetFilterType(int filterType) NN_NOEXCEPT;
    void SetLowPassFilterValue(float lowPassFilterValue) NN_NOEXCEPT;
    void SetBiquadFilterValue(float biquadFilterValue) NN_NOEXCEPT;
    void SetupFilter() NN_NOEXCEPT;
    void DumpFilterParam() NN_NOEXCEPT;
    void SetFilterParam(float handleLpfValue, float playerLpfValue, int handleBiquadType, float handleBiquadValue, int playerBiquadType, float playerBiquadValue) NN_NOEXCEPT;

private:
    // 初期値
    const float DefaultBiquadFilterValue = 0.8f;
    const float DefaultLowPassFilterValue = -0.3f;

    // 最大値、最小値
    const float LowPassFilterValueMin = -1.0f;
    const float LowPassFilterValueMax = 0.0f;
    const float BiquadFilterValueMin = 0.0f;
    const float BiquadFilterValueMax = 1.0f;

    // 変化量
    const float ChangeFilterValue = 0.1f;
    const float RoundFilterValue = 0.001f;

private:
    CommonObject m_CommonObject;

    SampleRateType m_SampleRateType;
    int m_FilterType;
    float m_BiquadFilterValue;
    float m_LowPassFilterValue;
};
