﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Simple.h"

#include "../FlagList.h"
#include "../GfxCode/DebugViewer.h"

namespace
{
    FlagList g_LocalFlagList(nullptr, 0);
}

void SimpleCheckModule::OnInitializeAtk() NN_NOEXCEPT
{
    m_CommonObject.Initialize();
}

void SimpleCheckModule::OnFinalizeAtk() NN_NOEXCEPT
{
    m_CommonObject.Finalize();
}

void SimpleCheckModule::OnLoadData() NN_NOEXCEPT
{
    m_CommonObject.LoadData();
}

void SimpleCheckModule::OnPrintUsage() NN_NOEXCEPT
{
    m_CommonObject.PrintUsage();

    //NN_LOG("[Down]         StartSound SEQ  (SEQ_MARIOKART)\n");
    //NN_LOG("[Up]           StartSound SEQ  (SEQ_MARIOKART_PLAYERHEAP)\n");
    //NN_LOG("[Left]         StartSound WSD  (SE_YOSHI_PLAYERHEAP)\n");
    //NN_LOG("[Right]        StartSound WSD  (SE_YOSHI_PLAYERHEAP_FOR_USERGROUP)\n");
}

void SimpleCheckModule::OnUpdateInput() NN_NOEXCEPT
{
    m_CommonObject.UpdateInput();

    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Down >() )
    {
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Up >() )
    {
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Left >() )
    {
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Right >() )
    {
    }
}

void SimpleCheckModule::OnUpdateAtk() NN_NOEXCEPT
{
    m_CommonObject.Update();
}

void SimpleCheckModule::OnUpdateDraw() NN_NOEXCEPT
{
    m_CommonObject.UpdateDraw(GetModuleName());
}

const char* SimpleCheckModule::GetModuleName() const NN_NOEXCEPT
{
    return "Simple";
}

FlagList& SimpleCheckModule::GetLocalFlagList() NN_NOEXCEPT
{
    return g_LocalFlagList;
}
