﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "EditGlobalFlag.h"

#include "../FlagList.h"
#include "../GfxCode/DebugViewer.h"

namespace
{
    FlagList g_LocalFlagList(nullptr, 0);
}

void EditGlobalFlagModule::OnInitializeAtk() NN_NOEXCEPT
{
    m_SelectedGlobalFlagIndex = 0;
}

void EditGlobalFlagModule::OnFinalizeAtk() NN_NOEXCEPT
{
}

void EditGlobalFlagModule::OnLoadData() NN_NOEXCEPT
{
}

void EditGlobalFlagModule::OnPrintUsage() NN_NOEXCEPT
{
    NN_LOG("[Up/Down]      Select Global Flag\n");
    NN_LOG("[X]            Change Selected Global Flag\n");
}

void EditGlobalFlagModule::OnPostPrintUsage() NN_NOEXCEPT
{
    ShowFlags();
}

void EditGlobalFlagModule::OnUpdateInput() NN_NOEXCEPT
{
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Down >() )
    {
        if (GetGlobalFlagList().GetFlagCount() > 0)
        {
            ++m_SelectedGlobalFlagIndex;
            if (m_SelectedGlobalFlagIndex >= GetGlobalFlagList().GetFlagCount())
            {
                m_SelectedGlobalFlagIndex = 0;
            }
            ShowFlags();
        }
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Up >() )
    {
        if (GetGlobalFlagList().GetFlagCount() > 0)
        {
            --m_SelectedGlobalFlagIndex;
            if (m_SelectedGlobalFlagIndex < 0)
            {
                m_SelectedGlobalFlagIndex = GetGlobalFlagList().GetFlagCount() - 1;
            }
            ShowFlags();
        }
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::X >() )
    {
        if (GetGlobalFlagList().GetFlagCount() > 0)
        {
            GetGlobalFlagList().SetFlagEnabled(
                m_SelectedGlobalFlagIndex,
                !GetGlobalFlagList().IsFlagEnabled(m_SelectedGlobalFlagIndex));
            ShowFlags();
        }
    }
}

void EditGlobalFlagModule::OnUpdateAtk() NN_NOEXCEPT
{
}

void EditGlobalFlagModule::OnUpdateDraw() NN_NOEXCEPT
{
    // モジュール名の表示
    DebugPrint("ModuleName", 0, 800, 0.6f, 0.8f, GetModuleName());
}

FlagList& EditGlobalFlagModule::GetLocalFlagList() NN_NOEXCEPT
{
    return g_LocalFlagList;
}

void EditGlobalFlagModule::ShowFlags() NN_NOEXCEPT
{
    NN_LOG("---------- Global Flags ----------\n");
    GetGlobalFlagList().ShowFlags(m_SelectedGlobalFlagIndex, false);
    NN_LOG("\n");
}
