﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdarg>
#include <memory>

#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

#include <nns/console/console_SimpleConsole.h>

template <class ProgramImpl>
class ProgramBase
    : public nns::console::SimpleConsole
{
protected:
    void Printfln(const char* format, ...) NN_NOEXCEPT
    {
        const auto DisplayLengthMax = 128;

        va_list args;
        va_start(args, format);
        const auto L = nn::util::VSNPrintf(nullptr, 0, format, args);
        const auto BufferSize = L + 2;
        std::unique_ptr<char[]> buffer(new char[BufferSize]);
        nn::util::VSNPrintf(buffer.get(), BufferSize, format, args);
        va_end(args);

        // ログ出力は省略しない
        NN_LOG(buffer.get());
        NN_LOG("\n");

        // 画面表示は切り詰める
        const auto End = std::min(L, DisplayLengthMax);
        std::strncpy(buffer.get() + End, "\n", BufferSize - End);
        nns::console::SimpleConsole::Puts(buffer.get());
    }

    // アプリケーションのメイン
    virtual void Execute() NN_NOEXCEPT = 0;

public:
    static void ThreadFunction(void* arg) NN_NOEXCEPT
    {
        reinterpret_cast<ProgramImpl*>(arg)->Execute();
    }
};
