﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include "g3ddemo_GfxUtility.h"

namespace g3ddemo = nn::g3d::demo;

// レンダラー
void InitializeRenderer() NN_NOEXCEPT;
void FinalizeRenderer() NN_NOEXCEPT;
void UpdateRenderer(nns::g3d::RenderView* pView, int viewIndex) NN_NOEXCEPT;

// ユニフォームブロック
void InitializeUniformBlocks() NN_NOEXCEPT;
void FinalizeUniformBlocks() NN_NOEXCEPT;
void UpdateUniformBlock(int bufferIndex) NN_NOEXCEPT;

// 描画コマンド
void MakeModelDrawCommand(nn::gfx::CommandBuffer* pCommandBuffer, int bufferIndex) NN_NOEXCEPT;
void MakeBoundingDrawCommand(nn::gfx::CommandBuffer* pCommandBuffer, int bufferIndex) NN_NOEXCEPT;
void MakeGridDrawCommand(nn::gfx::CommandBuffer* pCommandBuffer, int bufferIndex) NN_NOEXCEPT;
void MakeSkeletonDrawCommand(nn::gfx::CommandBuffer* pCommandBuffer, int bufferIndex) NN_NOEXCEPT;
void MakeWireframeDrawCommand(nn::gfx::CommandBuffer* pCommandBuffer, float lineWidth, int bufferIndex) NN_NOEXCEPT;

// グリッド描画
class GridRenderer
{
    NN_DISALLOW_COPY(GridRenderer);
public:
    GridRenderer() NN_NOEXCEPT
        : m_Interval(1.0f)
        , m_Width(m_Interval * 100.0f)
        , m_LineWidth(1.0f)
        , m_Color(nn::util::Color4u8::White())
        , m_pRenderer(NULL)
    {
    }

    void Initialize(nns::gfx::PrimitiveRenderer::Renderer* pRenderer) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void Draw(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;

    void SetInterval(float interval) NN_NOEXCEPT
    {
        m_Interval = interval;
    }

    void SetWidth(float width) NN_NOEXCEPT
    {
        m_Width = width;
    }

    void SetLineWidth(float width) NN_NOEXCEPT
    {
        m_LineWidth = width;
    }

    void SetColor(nn::util::Color4u8 color) NN_NOEXCEPT
    {
        m_Color = color;
    }

private:
    float m_Interval; // グリッドの描画間隔
    float m_Width; // グリッドの描画範囲
    float m_LineWidth; // 線の太さ
    nn::util::Color4u8 m_Color; // 線の色
    nns::gfx::PrimitiveRenderer::Renderer* m_pRenderer;
};

// スケルトン描画
class SkeletonRenderer
{
public:
    SkeletonRenderer() NN_NOEXCEPT
        : m_JointRadius(30.0f)
        , m_SelectedBoneIndex(InvalidBoneIndex)
        , m_SelectedJointColor(nn::util::Color4u8::White())
        , m_DefaultJointColor(nn::util::Color4u8::White())
        , m_pRenderer(NULL)
    {
    }

    void Initialize(nns::gfx::PrimitiveRenderer::Renderer* pRenderer) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    void Draw(nn::gfx::CommandBuffer* pCommandBuffer, nn::g3d::ModelObj* pModelObj) NN_NOEXCEPT;

    void SetSelectedJointColor(const nn::util::Color4u8& selectedJointColor) NN_NOEXCEPT
    {
        m_SelectedJointColor = selectedJointColor;
    }

    void SetDefaultJointColor(const nn::util::Color4u8& defaultJointColor) NN_NOEXCEPT
    {
        m_DefaultJointColor = defaultJointColor;
    }

    void SetJointRadius(float radius) NN_NOEXCEPT
    {
        m_JointRadius = radius;
    }

    void SetSelectedBoneIndex(int selectedBoneIndex) NN_NOEXCEPT
    {
        m_SelectedBoneIndex = selectedBoneIndex;
    }

public:
    static const int InvalidBoneIndex = -1;

private:
    float m_JointRadius;
    int m_SelectedBoneIndex;
    nn::util::Color4u8 m_SelectedJointColor;
    nn::util::Color4u8 m_DefaultJointColor;
    nns::gfx::PrimitiveRenderer::Renderer* m_pRenderer;
};
