﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/demo_DefaultAllocator.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/mem/defaultHeap.h>
#else
  #include <malloc.h>
#endif

namespace nw {
namespace demo {

#if defined( NW_PLATFORM_CAFE )

//---------------------------------------------------------------------------
void*
DefaultAllocator::Alloc( size_t size, u32 alignment )
{
    return MEMAllocFromDefaultHeapEx( size, alignment );
}

//---------------------------------------------------------------------------
void
DefaultAllocator::Free( void* memory )
{
    MEMFreeToDefaultHeap( memory );
}
#else

//---------------------------------------------------------------------------
void*
DefaultAllocator::Alloc( size_t size, u32 alignment )
{
    return _aligned_malloc( size, alignment );
}

//---------------------------------------------------------------------------
void
DefaultAllocator::Free( void* memory )
{
    return _aligned_free ( memory );
}

#endif


} // namespace nw::demo
} // namespace nw
