﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_V_PAD_CAFE_H_
#define NW_DEMO_V_PAD_CAFE_H_

#include <nw/demo/pad/demo_Pad.h>
#include <nw/demo/pad/cafe/demo_VPadDeviceCafe.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief        Cafe の VPAD を扱うクラスです。
//!
//! @details :category     入力デバイス
//---------------------------------------------------------------------------
class VPadCafe : public Pad
{
public:
    NW_UT_RUNTIME_TYPEINFO(Pad)

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    explicit VPadCafe();

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~VPadCafe() {}


    //---------------------------------------------------------------------------
    //! @brief        パッドが接続状態にあるか否かを返します。
    //!
    //! @return       接続されている場合、 true を返します。
    //---------------------------------------------------------------------------
    virtual bool IsConnected() const { return m_IsConnected; }

    //---------------------------------------------------------------------------
    //! @brief        パッドデバイスを設定します。
    //!
    //! @param[in]    device    設定するデバイスへのポインタです。
    //---------------------------------------------------------------------------
    void SetVPadDevice( VPadDeviceCafe* device ){ m_PadDevice = device; }

    //---------------------------------------------------------------------------
    //! @brief        VPAD パッド状態を取得します。
    //!
    //! @param[out]   pad        出力するパッド状態へのポインタです。
    //---------------------------------------------------------------------------
    void GetVPadStatus( VPADStatus* pad );


protected:
    virtual void UpdateImpl();

    bool m_IsConnected; //!< 接続されているかを表します。

    VPadDeviceCafe* m_PadDevice; //!< 使用するパッドデバイスです。
};

} // namespace demo
} // namespace nw

#endif // NW_DEMO_V_PAD_CAFE_H_
