﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_UTILITY_H_
#define NW_DEMO_UTILITY_H_

#include <nw/math.h>
#include <nw/ut/ut_Color.h>

namespace nw
{
namespace demo
{

//! @brief カラー値を SRGB 空間から Linear 空間へ変換します。
u8 SRGBToLinear(u8 src);

//! @brief カラー値を Linear 空間から SRGB 空間へ変換します。
u8 LinearToSRGB(u8 src);

//! @brief カラー値を SRGB 空間から Linear 空間へ変換します。
NW_INLINE nw::ut::Color4u8 SRGBToLinear(const nw::ut::Color4u8& src)
{
    return nw::ut::Color4u8(SRGBToLinear(src.r), SRGBToLinear(src.g), SRGBToLinear(src.b), src.a);
}

//! @brief カラー値を Linear 空間から SRGB 空間へ変換します。
NW_INLINE nw::ut::Color4u8 LinearToSRGB(const nw::ut::Color4u8& src)
{
    return nw::ut::Color4u8(LinearToSRGB(src.r), LinearToSRGB(src.g), LinearToSRGB(src.b), src.a);
}

//! @brief カラー値を SRGB 空間から Linear 空間へ変換します。
NW_INLINE nw::ut::Color4u8 SRGBToLinear(u32 src)
{
    return SRGBToLinear(nw::ut::Color4u8(src));
}

//! @brief カラー値を Linear 空間から SRGB 空間へ変換します。
NW_INLINE nw::ut::Color4u8 LinearToSRGB(u32 src)
{
    return LinearToSRGB(nw::ut::Color4u8(src));
}

} // namespace nw::demo
} // namespace nw

#endif // NW_DEMO_UTILITY_H_
