﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_DEFAULT_ALLOCATOR_H_
#define NW_DEMO_DEFAULT_ALLOCATOR_H_

#include <nw/types.h>
#include <nw/ut/ut_Memory.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief デフォルトヒープからメモリを確保する Allocator です。
//---------------------------------------------------------------------------
class DefaultAllocator : public ut::IAllocator
{
public:
    virtual void* Alloc( size_t size, u32 alignment );
    virtual void  Free( void* memory );

    void* Alloc(size_t size) { return ut::IAllocator::Alloc(size); }
};

} // namespace nw::demo
} // namespace nw

#endif // NW_DEMO_DEFAULT_ALLOCATOR_H_
