﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{GraphicsObjectSpecializedCube.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a class that derives from the base GraphicsObject
 *  class for drawing the graphicsObjectSpecializedCube.out asset file
 */

#pragma once

#include "GraphicsObject.h"
#include <nn/util/util_Matrix.h>
#include <unordered_map>

#include "TextureIDManager.h"

class UniformBufferManager;
class ManagedUniformBuffer;

struct UniformReflectionInfo
{
    uint32_t offset;
    uint32_t size;
};

struct UniformBlockReflectionInfo
{
    std::string blockName;
    uint32_t bindingLocation;
    uint32_t blockSize;

    std::unordered_map<std::string, UniformReflectionInfo> uniformInfo;
};

class GraphicsObjectSpecializedCube : public GraphicsObject
{
    public:
        NN_IMPLICIT GraphicsObjectSpecializedCube(TextureIDManager* pTextureIDManager);
        virtual ~GraphicsObjectSpecializedCube();

        virtual void SetScale(float x, float y, float z);
        virtual void SetTranslate(float x, float y, float z);
        virtual void SetRotate(float x, float y, float z);
        virtual void SetWorldMatrix(const nn::util::Matrix4x4fType& world);
        virtual void SetCameraMatrix(const nn::util::Matrix4x4fType& camera);
        virtual void SetProjectionMatrix(const nn::util::Matrix4x4fType& projection);

        virtual void Init(AssetFileDataHolder* pData);
        virtual void SetupUniforms(UniformBufferManager* pUniformBufferManager);
        virtual void UpdateUniforms();
        virtual void Draw(NVNcommandBuffer* pCommandBuffer) const;

        static  void ReceiveUniformBlockReflectionInformation(NVNshaderStageBits shaderStage, uint32_t bindingLocation, uint32_t blockSize, const std::string& blockName);
        static  void ReceiveUniformReflectionInformation(NVNshaderStageBits shaderStage, uint32_t offset, uint32_t dataSize, const std::string& uniformName);

        void SetShaderIndex(int index);

    private:
        int                                 m_ShaderIndex;

        ManagedUniformBuffer*               m_pUniformBlockVS;
        ManagedUniformBuffer*               m_pUniformBlockFS;

        TextureIDManager*                   m_pTextureIDManager;

        nn::util::Matrix4x4fType            m_WorldMatrix;

        float                               m_TranslateX;
        float                               m_TranslateY;
        float                               m_TranslateZ;

        float                               m_ScaleX;
        float                               m_ScaleY;
        float                               m_ScaleZ;

        float                               m_RotateX;
        float                               m_RotateY;
        float                               m_RotateZ;

        nn::util::Matrix4x4fType            m_CameraMatrix;
        nn::util::Matrix4x4fType            m_ProjectionMatrix;

        static UniformBlockReflectionInfo   vertBlockInfo;
        static UniformBlockReflectionInfo   fragBlockInfo;
};
