﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nns/console/detail/console_ConsoleGraphicsFramework.h>

namespace nns {
namespace console {

// SimpleConsole : 渡された文字列を表示するだけの単純なコンソール実装
class SimpleConsole
    : public nns::console::detail::ConsoleBase
{
private:
    static const size_t DefaultBufferSize;
    static const size_t BufferSizeMax;

    mutable nn::os::Mutex m_Lock;
    bool m_BlinkEnabled;
    int m_Counter;

    std::vector<const char*> m_LineBreaks;
    char* m_Buffer;
    size_t m_BufferSize;
    size_t m_CurrentLength;

    void UpdateLineBreaksUnsafe(const char* buffer) NN_NOEXCEPT;
    bool TryExpandBufferUnsafe(size_t expect) NN_NOEXCEPT;
    void Puts(const char* string, size_t size) NN_NOEXCEPT;

protected:
    virtual void UpdateImpl() NN_NOEXCEPT NN_OVERRIDE;
    virtual void MakeCommandImpl(nn::gfx::util::DebugFontTextWriter* pTextWriter) const NN_NOEXCEPT NN_OVERRIDE;

    void NoBlink() NN_NOEXCEPT
    {
        m_BlinkEnabled = false;
    }

public:
    SimpleConsole() NN_NOEXCEPT;
    ~SimpleConsole() NN_NOEXCEPT;

    void Puts(const char* string) NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
};

} // ~namespace nn::console
}

#undef NN_GFX_UTIL_DEBUGFONT_USE_DEFAULT_LOCALE_CHARSET
