﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Simple.h"

namespace
{

struct engine
{
    struct android_app* app;
};

// ディスプレイ初期化
int InitializeDisplay(struct engine* engine)
{
    SimpleInit(engine->app);
    return 0;
}

// 計算と描画
void CalculateDraw(struct engine* engine)
{
    if (nw::g3d::fnd::detail::GetEGLDisplay() == NULL)
    {
        // No display.
        return;
    }
    SimpleCalc();
    SimpleDraw();
}


// ディスプレイ破棄
void FinalizeDisplay(struct engine* engine)
{
    SimpleDestroy();
}

// コマンド処理
static void HandleCommand(struct android_app* app, int32_t cmd)
{
    struct engine* engine = (struct engine*)app->userData;
    switch (cmd) {
        case APP_CMD_SAVE_STATE:
            break;
        // ウィンドウが現れた
        case APP_CMD_INIT_WINDOW:
            if (engine->app->window != NULL) {
                InitializeDisplay(engine);
                CalculateDraw(engine);
            }
            break;
        // ウィンドウが消えたまたは終了
        case APP_CMD_TERM_WINDOW:
            FinalizeDisplay(engine);
            break;
        case APP_CMD_GAINED_FOCUS:
            break;
        case APP_CMD_LOST_FOCUS:
            CalcDraw(engine);
            break;
    }
}

}

// android_native_app_glueを使用したときのエントリーポイント
void android_main(struct android_app* state)
{
    struct engine engine;

    // ライブラリをリンクする際に、glueのコードがストリップされないようにするダミーの関数
    app_dummy();

    memset(&engine, 0, sizeof(engine));
    state->userData = &engine;
    state->onAppCmd = HandleCommand;
    engine.app = state;

    // ループ
    while (1)
    {
        int ident;
        int events;
        struct android_poll_source* source;

        // イベントループ
        while ((ident=ALooper_pollAll(0, NULL, &events, (void**)&source)) >= 0)
        {
            // イベント処理
            if (source != NULL)
            {
                source->process(state, source);
            }

            // 終了チェック
            if (state->destroyRequested != 0)
            {
                FinalizeDisplay(&engine);
                return;
            }
        }

        CalculateDraw(&engine);
    }
}

