﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#version 330

in vec4 uv_coef;
in vec4 color;

layout(location = 0) out vec4 o_Color;

uniform sampler2D tex;

void main()
{
    vec4 sample = texture(tex, uv_coef.xy).rgbr;
    // Shape: uv_coef.zw == (1, 0)
    // Font:  uv_coef.zw == (0, 1)
    o_Color.rgb = uv_coef.z * sample.rgb + uv_coef.w * color.rgb;
    o_Color.a = uv_coef.z * color.a + uv_coef.w * sample.r;
}
