﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.Spy
{
    public static class Disposer
    {
        public static void SafeDispose<TTarget>(ref TTarget target, Action disposedAction = null)
            where TTarget : class, IDisposable
        {
            if (target == null)
            {
                return;
            }

            target.Dispose();
            target = null;

            if (disposedAction != null)
            {
                disposedAction();
            }
        }
    }
}
