﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.Spy
{
    /// <summary>
    /// SpyTime の時間を比較します。
    /// CompareBy プロパティに指定された時間単位に応じた SpyTime のプロパティが比較に使われます。
    /// </summary>
    /// <remarks>
    /// 比較には SpyTime.Compare() が使われます。
    /// </remarks>
    public sealed class SpyTimeTimeUnitComparer : IComparer<SpyTime>
    {
        public SpyTimeUnit CompareBy { get; set; }

        public SpyTimeTimeUnitComparer()
        {
            this.CompareBy = SpyTimeUnit.Timestamp;
        }

        public SpyTimeTimeUnitComparer(SpyTimeUnit timeUnit)
        {
            this.CompareBy = timeUnit;
        }

        /// <summary>
        /// CompareBy プロパティに指定された時間単位に応じた SpyTime のプロパティを使って SpyTime の時間を比較します。
        /// </summary>
        /// <param name="x">比較する最初のオブジェクト</param>
        /// <param name="y">比較する２番目のオブジェクト</param>
        /// <returns>
        /// x &lt; y なら負の値を返します。
        /// x == y なら 0 を返します。
        /// x &gt; y なら正の値を返します。
        /// </returns>
        /// <remarks>
        /// 比較には SpyTime.Compare() が使われます。
        /// CompareBy プロパティに SpyTimeUnit.Timestamp が指定された場合、 SpyTime.Timestamp のマイクロ秒の桁は無視されます。
        /// </remarks>
        public int Compare(SpyTime x, SpyTime y)
        {
            return SpyTime.Compare(x, y, this.CompareBy);
        }
    }
}
