﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel.Composition;

namespace NintendoWare.Spy.Plugins
{
    /// <summary>
    /// Spy コネクションプラグインです。
    /// このクラスを継承することで新しい接続先をフレームワークに登録します。
    /// </summary>
    [InheritedExport(typeof(SpyConnectionPlugin))]
    public abstract class SpyConnectionPlugin
    {
        /// <summary>
        /// 対象プラットフォーム名を取得します。
        /// </summary>
        public abstract string TargetPlatformName { get; }

        /// <summary>
        /// NintendoSDK 対応のプラグインかどうかを示します。
        /// </summary>
        public virtual bool IsForNintendoSDK
        {
            get { return true; }
        }

        /// <summary>
        /// 小さいイメージの URI を取得します。
        /// </summary>
        public abstract string SmallImageUri { get; }

        /// <summary>
        /// 大きいイメージの URI を取得します。
        /// </summary>
        public abstract string LargeImageUri { get; }

        /// <summary>
        /// 大きい切断イメージの URI を取得します。
        /// </summary>
        public abstract string LargeDisconnectedImageUri { get; }

        /// <summary>
        /// UI に表示するテキストを取得します。
        /// </summary>
        public abstract string Text { get; }

        /// <summary>
        /// Sync ポートの接続パラメータを取得します。
        /// </summary>
        /// <param name="connectionSettings"></param>
        /// <returns></returns>
        public virtual object GetSyncPort(Settings.ConnectionSettings connectionSettings)
        {
            return null;
        }

        /// <summary>
        /// Data ポートの接続パラメータを取得します。
        /// </summary>
        /// <param name="connectionSettings"></param>
        /// <returns></returns>
        public virtual object GetDataPort(Settings.ConnectionSettings connectionSettings)
        {
            return null;
        }
    }
}
