﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Reflection;
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy.Foundation
{
    public class ApplicationInfoService : ObservableObject
    {
        private Assembly _mainAssembly;
        private IApplicationInfo _applicationInfo;

        //-----------------------------------------------------------------

        public IApplicationInfo ApplicationInfo
        {
            get { return _applicationInfo; }
            private set { this.SetPropertyValue(ref _applicationInfo, value); }
        }

        //-----------------------------------------------------------------

        public void Initialize(Assembly mainAssembly)
        {
            Ensure.Argument.NotNull(mainAssembly);

            _mainAssembly = mainAssembly;
            this.ApplicationInfo = Foundation.ApplicationInfo.FromAssembly(mainAssembly);
        }

        public void Uninitialize()
        {
            _mainAssembly = null;
            this.ApplicationInfo = null;
        }
    }
}
