﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.ToolFoundation.Metadata;

namespace NintendoWare.Spy.Foundation
{
    /// <summary>
    /// アプリケーション情報を格納します。
    /// </summary>
    public class ApplicationInfo : IApplicationInfo
    {
        public string Name { get; set; }

        public Version Version { get; set; }

        public string VersionPhase { get; set; }

        public string Copyright { get; set; }

        public Icon Icon { get; set; }

        //-----------------------------------------------------------------

        /// <summary>
        /// アセンブリからアプリケーション情報を生成します。
        /// </summary>
        /// <param name="assembly">アセンブリを指定します。</param>
        /// <returns>アプリケーション情報を返します。</returns>
        public static ApplicationInfo FromAssembly(Assembly assembly)
        {
            Ensure.Argument.NotNull(assembly);

            FileVersionInfo fileVersionInfo = FileVersionInfo.GetVersionInfo(assembly.Location);

            var result = new ApplicationInfo();

            result.Name = AssemblyHelper.GetAssemblyTitle(assembly);
            result.Version = new Version(
                fileVersionInfo.ProductMajorPart,
                fileVersionInfo.ProductMinorPart,
                fileVersionInfo.ProductBuildPart,
                fileVersionInfo.ProductPrivatePart);
            result.Copyright = AssemblyHelper.GetAssemblyCopyright(assembly);

            return result;
        }
    }
}
