﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;

namespace NintendoWare.Spy.Extensions
{
    /// <summary>
    /// <see cref="IServiceProvider"/> の拡張メソッドです。
    /// </summary>
    public static class IServiceProviderExtension
    {
        /// <summary>
        /// 指定したサービスを取得します。
        /// </summary>
        /// <typeparam name="TService">サービスの型を指定します。</typeparam>
        /// <param name="serviceProvider">サービスプロバイダを指定します。</param>
        /// <returns>サービスを返します。</returns>
        public static TService GetService<TService>(this IServiceProvider serviceProvider)
            where TService : class
        {
            Ensure.Argument.NotNull(serviceProvider);
            return (TService)serviceProvider.GetService(typeof(TService));
        }
    }
}
