﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;

namespace NintendoWare.Spy.Extensions
{
    /// <summary>
    /// 配列の拡張メソッドです。
    /// </summary>
    public static class ArrayExtension
    {
#if false // この実装は低速。おそらくリフレクションを使うため。
        private static T[] Populate<T>(this T[] a)
            where T : new()
        {
            Ensure.Argument.NotNull(a);

            for (int i = 0; i < a.Length; ++i)
            {
                a[i] = new T();
            }

            return a;
        }
#endif

        /// <summary>
        /// 配列のすべての要素に値を設定します。
        /// 例:
        /// <code>
        /// var list = new int[100].Populate(-1);
        /// </code>
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="a"></param>
        /// <param name="value">すべての要素に格納されます。</param>
        /// <returns>引数 a を返します。</returns>
        public static T[] Populate<T>(this T[] a, T value)
        {
            Ensure.Argument.NotNull(a);

            for (int i = 0; i < a.Length; ++i)
            {
                a[i] = value;
            }

            return a;
        }

        /// <summary>
        /// 配列のすべての要素に値を設定します。
        /// 例:
        /// <code>
        /// var list = new int[100].Populate(i => i * i);
        /// </code>
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="a"></param>
        /// <param name="factory">要素ごとに呼び出され、戻り値が要素に格納されます。引数に要素の番号(0~)が渡されます。</param>
        /// <returns>引数 a を返します。</returns>
        public static T[] Populate<T>(this T[] a, Func<int, T> factory)
        {
            Ensure.Argument.NotNull(a);
            Ensure.Argument.NotNull(factory);

            for (int i = 0; i < a.Length; ++i)
            {
                a[i] = factory(i);
            }

            return a;
        }
    }
}
