﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation;
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.Reflection;

namespace NintendoWare.Spy.Communication
{
    internal class InitializePacket : Packet<InitializePacket.Content>
    {
        public InitializePacket() :
            base(SpySession._Signature, (uint)PacketID.Initialize)
        { }

        //-----------------------------------------------------------------

        [SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1121:UseBuiltInTypeAlias", Justification = "バイナリのサイズを明示するため")]
        public class Content : PacketBody
        {
            public override uint Size
            {
                get
                {
                    return (uint)sizeof(UInt32);
                }
            }

            public UInt32 ValidSpyDataIDFlags { get; set; }

            protected override IEnumerable<PropertyInfo> GetProperties()
            {
                yield return this.GetProperty(target => target.ValidSpyDataIDFlags);
            }
        }
    }

    internal class InitializeReplyPacket : Packet<InitializeReplyPacket.Content>
    {
        public InitializeReplyPacket() :
            base(SpySession._Signature, (uint)PacketID.InitializeReply)
        {
            this.Body.Owner = this;
        }

        public class Content : PacketBody
        {
            internal InitializeReplyPacket Owner { get; set; }

            // パケットの読み出しでは意味を持ちませんが、ヘッダの初期化に使われるので 0 を返しておきます。
            public override uint Size { get { return 0; } }

            /// <summary>
            /// プロトコルバージョン
            /// </summary>
            public Version ProtocolVersion { get; set; }

            protected override IEnumerable<PropertyInfo> GetProperties()
            {
                Ensure.Operation.NotNull(this.Owner);

                if (this.Owner.Header.Size >= 4)
                {
                    yield return this.GetProperty(target => target.ProtocolVersion);
                }
            }
        }
    }
}
