﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation;
using NintendoWare.Spy.Foundation.Commands;
using System.Windows;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// ファイル保存（ダイアログ）コマンドの引数。
    /// </summary>
    public class SaveFileDialogCommandArgs : CommandArgs, IDeepClonable
    {
        public string Title { get; set; }

        public string FileName { get; set; }

        public string Filter { get; set; }

        public int FilterIndex { get; set; }

        public string DefaultExtension { get; set; }

        public string InitialDirectory { get; set; }

        public bool CheckFileExists { get; set; }

        public bool CheckPathExists { get; set; }

        public Window OwnerWindow { get; set; }

        public SaveFileDialogCommandArgs()
        {
        }

        object IDeepClonable.DeepClone()
        {
            return this.DeepCloneTo(new SaveFileDialogCommandArgs());
        }

        protected object DeepCloneTo(SaveFileDialogCommandArgs to)
        {
            base.DeepCloneTo(to);

            to.Title = this.Title;
            to.FileName = this.FileName;
            to.Filter = this.Filter;
            to.FilterIndex = this.FilterIndex;
            to.DefaultExtension = this.DefaultExtension;
            to.InitialDirectory = this.InitialDirectory;
            to.CheckFileExists = this.CheckFileExists;
            to.CheckPathExists = this.CheckPathExists;
            to.OwnerWindow = this.OwnerWindow;

            return to;
        }
    }
}
