﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Framework.Settings;

namespace NintendoWare.Spy.Settings
{
    /// <summary>
    /// UI 設定へのアクセスを簡略化するヘルパークラスです。
    /// </summary>
    public static class UISettingsAccessor
    {
        /// <summary>
        /// ウィンドウ設定を取得します。
        /// </summary>
        /// <param name="service">SettingsService を指定します。</param>
        /// <returns>WindowSettings を返します。</returns>
        public static WindowsSettings GetWindowsSettings(this SettingsService service)
        {
            return service.GetSettingItemValue<WindowsSettings>(UIConstConfig.SettingItemKeys.WindowsSettingsKey);
        }
    }
}
