﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Foundation.Commands;
using Forms = System.Windows.Forms;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// Spy ログのすべて記録コマンドのハンドラです。
    /// </summary>
    internal static class SpyRecordAllFilesHandler
    {
        public static CommandStatus CanExecute(RecordAllFilesCommandArgs commandArgs)
        {
            if (commandArgs == null)
            {
                return CommandStatus.Unsupported;
            }

            if (commandArgs.SpyService == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.SpyService.IsLoading == true)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.IsConnecting == true)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.SpyService.HasRecordedData == false && commandArgs.SpyService.HasLoadedData == false)
            {
                return CommandStatus.Disabled;
            }

            return CommandStatus.Enabled;
        }

        public static CommandResult Execute(RecordAllFilesCommandArgs commandArgs)
        {
            Ensure.Operation.True(CanExecute(commandArgs).IsEnabled());

            try
            {
                var dialog = new Forms.FolderBrowserDialog();
                dialog.SelectedPath = commandArgs.OutputDirectoryPath;

                Forms.DialogResult result = dialog.ShowDialog();
                if (result != Forms.DialogResult.OK)
                {
                    return CommandResult.CreateCanceled();
                }

                commandArgs.SpyService.CopyAllRecordedFiles(DirectoryUtility.GetDateTimePath(dialog.SelectedPath));

                return CommandResult.CreateSucceeded(dialog.SelectedPath);
            }
            catch
            {
                return CommandResult.CreateSucceeded();
            }
        }
    }
}
