﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.NxSpyPlugin.Foundation.Platform;
using NintendoWare.Spy.Foundation.Communications.Htcs;
using NintendoWare.Spy.Plugins;
using NintendoWare.Spy.Settings;

namespace NintendoWare.NxSpyPlugin.Plugins
{
    /// <summary>
    /// NX へのコネクションプラグインです。
    /// </summary>
    public sealed class NXConnectionPlugin : SpyConnectionPlugin
    {
        /// <summary>
        /// 対象プラットフォーム名を取得します。
        /// </summary>
        public override string TargetPlatformName
        {
            get { return PlatformNX.Name; }
        }

        /// <summary>
        /// 小さいイメージの URI を取得します。
        /// </summary>
        public override string SmallImageUri
        {
            get { return "pack://application:,,,/NxSpyPlugin;component/Resources/Images/NxSmall.png"; }
        }

        /// <summary>
        /// 大きいイメージの URI を取得します。
        /// </summary>
        public override string LargeImageUri
        {
            get { return "pack://application:,,,/NxSpyPlugin;component/Resources/Images/NxLarge.png"; }
        }

        /// <summary>
        /// 大きい切断イメージの URI を取得します。
        /// </summary>
        public override string LargeDisconnectedImageUri
        {
            get { return "pack://application:,,,/NxSpyPlugin;component/Resources/Images/NxLargeDisconnected.png"; }
        }

        /// <summary>
        /// UI に表示するテキストを取得します。
        /// </summary>
        public override string Text
        {
            get { return Resources.Labels.ConnectToNX; }
        }

        /// <summary>
        /// Sync ポートの接続パラメータを取得します。
        /// </summary>
        /// <param name="connectionSettings"></param>
        /// <returns></returns>
        public override object GetSyncPort(ConnectionSettings connectionSettings)
        {
            return HostIOHtcs.SyncPortName;
        }

        /// <summary>
        /// Data ポートの接続パラメータを取得します。
        /// </summary>
        /// <param name="connectionSettings"></param>
        /// <returns></returns>
        public override object GetDataPort(ConnectionSettings connectionSettings)
        {
            return HostIOHtcs.DataPortName;
        }
    }
}
