﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.InGameEditing.Communication;
using NintendoWare.NxSpyPlugin.Foundation.Platform;
using NintendoWare.Spy.Foundation.Communications;
using NintendoWare.Spy.Foundation.Communications.Htcs;
using System;
using System.Text.RegularExpressions;

namespace NintendoWare.NxSpyPlugin.Foundation.Communications.Htcs
{
    public sealed class HostIOHtcsPluginNX : HostIOPlugin
    {
        private static readonly Lazy<HostIOHtcs> FieldInstance = new Lazy<HostIOHtcs>(() => new HostIOHtcs(IsTargetPort));

        private static Regex regexPeerType = new Regex(@"^NX-");
        private static Regex regexPeerTypeWindows = new Regex(@"^NX-Windows$");

        public override string Platform
        {
            get { return PlatformNX.Name; }
        }

        //-----------------------------------------------------------------

        protected override IComEndPoint GetHostIOImpl()
        {
            return FieldInstance.Value;
        }

        /// <summary>
        /// 接続対象であるか判定します。
        /// スペックが NX の場合に接続対象とします。
        /// ただしプラットフォームが Windows の場合は除きます(その場合は HtcsWin で接続します)。
        /// </summary>
        /// <param name="targetInfo"></param>
        /// <param name="portInfo"></param>
        /// <returns></returns>
        private static bool IsTargetPort(TargetInfo targetInfo, PortInfo portInfo)
        {
            bool isTarget = regexPeerType.IsMatch(targetInfo.PeerType) && !regexPeerTypeWindows.IsMatch(targetInfo.PeerType);
            return isTarget;
        }
    }
}
