﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    /// <summary>
    /// TimelineItem.xaml で参照したい依存プロパティを定義するクラスです。
    /// </summary>
    public class TimelineItemBase : Canvas
    {
        /// <summary>
        /// アイテムが選択されているか
        /// </summary>
        public bool IsSelected
        {
            get { return (bool)this.GetValue(IsSelectedProperty); }
            set { this.SetValue(IsSelectedProperty, value); }
        }

        /// <summary>
        /// アイテムが選択されているかを表す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty IsSelectedProperty =
            DependencyProperty.Register(
                nameof(IsSelected),
                typeof(bool),
                typeof(TimelineItemBase),
                new FrameworkPropertyMetadata(false, FrameworkPropertyMetadataOptions.BindsTwoWayByDefault, OnIsSelectedPropertyChanged));

        private static void OnIsSelectedPropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            var self = (TimelineItemBase)d;
            self.RaiseEvent(new RoutedEventArgs(IsSelectedChangedEvent));
        }

        public static readonly RoutedEvent IsSelectedChangedEvent =
            EventManager.RegisterRoutedEvent(
                nameof(IsSelectedChanged),
                RoutingStrategy.Bubble,
                typeof(RoutedEventHandler),
                typeof(TimelineItemBase));

        public event RoutedEventHandler IsSelectedChanged
        {
            add { AddHandler(IsSelectedChangedEvent, value); }
            remove { RemoveHandler(IsSelectedChangedEvent, value); }
        }
    }
}
