﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.NwSoundSpyPlugin.Models;
using NintendoWare.NwSoundSpyPlugin.Plugins;
using NintendoWare.Spy;
using NintendoWare.Spy.Windows;
using System.Threading;
using System.Windows.Controls;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    public class PlayingSoundPanelPresenter : SpyPanelPresenter
    {
        private readonly object _observerOwner = new object();
        private PlayingSoundPanelViewModel _viewModel = null;
        private PlayingSoundPanel _view = null;

        public PlayingSoundPanelPresenter()
        {
            _viewModel = new PlayingSoundPanelViewModel()
            {
                SyncContext = SynchronizationContext.Current,
            };
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            PropertyChangedObservation.GetObserver(_observerOwner, this.GetPlaybackService())
                .AddHandler(
                    target => target.Current,
                    (target, args) => UpdateGlobalCurrentPosition());

            this.UpdateGlobalCurrentPosition();
        }

        protected override void OnUninitialize()
        {
            PropertyChangedObservation.RemoveObservers(_observerOwner);

            Disposer.SafeDispose(ref _viewModel);

            base.OnUninitialize();
        }

        protected override Control CreateContent()
        {
            _view = new PlayingSoundPanel()
            {
                DataContext = _viewModel
            };
            return _view;
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            switch (dataName)
            {
                case SoundStatusInfoSpyModelPlugin.SpyDataName:
                    {
                        var theModel = model as SoundStatusInfoSpyModel;
                        _viewModel.SetModel(theModel);
                    }
                    break;

                case SoundDataInfoSpyModelPlugin.SpyDataName:
                    {
                        var theModel = model as SoundDataInfoSpyModel;
                        _viewModel.SetModel(theModel);
                    }
                    break;
            }
        }

        ///
        private void UpdateGlobalCurrentPosition()
        {
            if (_view == null)
            {
                return;
            }

            var playbackService = this.GetPlaybackService();
            var current = playbackService.Current;
            _viewModel.CurrentTime = current;
        }
    }
}
