﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Foundation;
using NintendoWare.Spy.Framework.Settings;
using NintendoWare.Spy.Settings;
using System.Diagnostics;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    internal class CafeAudioRibbonTabPresenter
    {
        private ServiceProvider _serviceProvider;
        private NwSoundRibbonTabViewModel _viewModel;
        private NwSoundRibbonTab _view;

        public Fluent.RibbonTabItem Tab { get { return _view; } }

        public CafeAudioRibbonTabPresenter(ServiceProvider serviceProvider)
        {
            Ensure.Argument.NotNull(serviceProvider);

            _serviceProvider = serviceProvider;

            _viewModel = new NwSoundRibbonTabViewModel();

            this.ApplyFromCafeAudioSettings();

            PropertyChangedObservation.GetObserver(this, _viewModel.NwSoundSettings)
                .AddHandlerForAnyProperties((target, args) => this.ApplyToCafeAudioSettings());

            this.GetSettingsService().Applied += (sender, args) => this.ApplyFromCafeAudioSettings();

            _view = new NwSoundRibbonTab()
            {
                DataContext = _viewModel,
            };
        }

        private void ApplyFromCafeAudioSettings()
        {
            var cafeAudioSettings = GetSettingsService().GetCafeAudioSettings();
            _viewModel.NwSoundSettings.FinalOutTvWaveVisibility = cafeAudioSettings.FinalOutTvWaveVisibility;
            _viewModel.NwSoundSettings.FinalOutDrcWaveVisibility = cafeAudioSettings.FinalOutDrcWaveVisibility;
            _viewModel.NwSoundSettings.LoudnessTvWaveVisibility = cafeAudioSettings.LoudnessTvWaveVisibility;
            _viewModel.NwSoundSettings.LoudnessDrcWaveVisibility = cafeAudioSettings.LoudnessDrcWaveVisibility;
        }

        private void ApplyToCafeAudioSettings()
        {
            var cafeAudioSetting = GetSettingsService().GetCafeAudioSettings();
            cafeAudioSetting.FinalOutTvWaveVisibility = _viewModel.NwSoundSettings.FinalOutTvWaveVisibility;
            cafeAudioSetting.FinalOutDrcWaveVisibility = _viewModel.NwSoundSettings.FinalOutDrcWaveVisibility;
            cafeAudioSetting.LoudnessTvWaveVisibility = _viewModel.NwSoundSettings.LoudnessTvWaveVisibility;
            cafeAudioSetting.LoudnessDrcWaveVisibility = _viewModel.NwSoundSettings.LoudnessDrcWaveVisibility;

            this.GetSettingsService().Apply();
        }

        [DebuggerStepThrough]
        private SettingsService GetSettingsService()
        {
            return _serviceProvider.GetService<SettingsService>();
        }
    }
}
