﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.NnAtkSpyPlugin.Plugins;
using NintendoWare.Spy;
using NintendoWare.Spy.Framework.Settings;
using NintendoWare.Spy.Settings;
using NintendoWare.Spy.Windows;
using System.Threading;
using System.Windows.Controls;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class SequenceVariablePanelPresenter : SpyPanelPresenter
    {
        private readonly object _observerOwner = new object();
        private readonly object _settingsObserverOwner = new object();
        private readonly SequenceVariablePanelViewModel _viewModel;
        private SequenceVariablePanel _view = null;
        private SpyTimeUnit _timeUnit;

        public SequenceVariablePanelPresenter()
        {
            _viewModel = new SequenceVariablePanelViewModel()
            {
                SyncContext = SynchronizationContext.Current,
            };
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            PropertyChangedObservation.GetObserver(_observerOwner, this.GetPlaybackService())
                .AddHandler(
                    target => target.Current,
                    (target, args) => UpdateGlobalCurrentPosition());

            this.UpdateGlobalCurrentPosition();
        }

        protected override void OnUninitialize()
        {
            PropertyChangedObservation.RemoveObservers(_observerOwner);
            PropertyChangedObservation.RemoveObservers(_settingsObserverOwner);

            _viewModel.Dispose();

            base.OnUninitialize();
        }

        protected override Control CreateContent()
        {
            _view = new SequenceVariablePanel()
            {
                DataContext = _viewModel
            };
            return _view;
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            switch (dataName)
            {
                case AtkSpyModelPlugin.SpyDataName:
                    _viewModel.SetModel(model as AtkSpyModel);
                    break;
            }
        }

        private void ApplySettings(ApplicationSettings settings)
        {
            if (settings != null)
            {
                _timeUnit = settings.TimeUnit;
            }

            if (_viewModel != null)
            {
                _viewModel.TimeUnit = _timeUnit;
            }
        }

        protected override void OnSettingsApplied(SettingsService service)
        {
            this.ApplySettings(service.GetApplicationSettings());

            PropertyChangedObservation.RemoveObservers(_settingsObserverOwner);

            PropertyChangedObservation.GetObserver(_settingsObserverOwner, service.GetApplicationSettings())
                .AddHandlerForAnyProperties(
                    (target, args) => ApplySettings(target));

            base.OnSettingsApplied(service);
        }

        private void UpdateGlobalCurrentPosition()
        {
            if (_view == null)
            {
                return;
            }

            var playbackService = this.GetPlaybackService();
            var current = playbackService.Current;
            _viewModel.CurrentTime = current;
        }
    }
}
