﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class PlayingSoundItemViewModel : ObservableObject
    {
        public enum PlayKinds
        {
            Loop,
            Oneshot,
        }

        /// <summary>
        /// ステートタイプ
        /// </summary>
        public enum StateType
        {
            Preapre = 0,
            Playing,
            Pause,
            None,
        }

        private string _assetName = string.Empty;
        private string _groupName = string.Empty;
        private string _archiveName = string.Empty;
        private float _volume;
        private float _resourceVolume;
        private float _priority;
        private PlayKinds _playKind;
        private StateType _state;
        private float _pitch;
        private float _lpf;
        private int _biquadFilterType;
        private float _biquadFilterValue;
        private int _playerPriority;
        private float _pan;
        private float _surroundPan;

        private bool _isAlive;
        private bool _isFiltered;
        private bool _isVisible;
        private bool _isAudible;

        ///
        public PlayingSoundItemViewModel()
        {
        }

        public uint InstanceID { get; set; }

        public uint SoundID { get; set; }

        public uint SoundArchiveInstanceId { get; set; }

        ///
        public bool IsAlive
        {
            get
            {
                return _isAlive;
            }
            set
            {
                this.SetPropertyValue(ref _isAlive, value);
                this.UpdateVisible();
            }
        }

        public bool IsFiltered
        {
            get
            {
                return _isFiltered;
            }
            set
            {
                this.SetPropertyValue(ref _isFiltered, value);
                this.UpdateVisible();
            }
        }

        public bool IsVisible
        {
            get
            {
                return _isVisible;
            }
            private set
            {
                this.SetPropertyValue(ref _isVisible, value);
            }
        }

        public StateType State
        {
            get
            {
                return _state;
            }
            set
            {
                this.SetPropertyValue(ref _state, value);
            }
        }

        public bool IsAudible
        {
            get
            {
                return _isAudible;
            }
            set
            {
                this.SetPropertyValue(ref _isAudible, value);
            }
        }

        public string SoundName
        {
            get
            {
                return _assetName;
            }
            set
            {
                this.SetPropertyValue(ref _assetName, value);
            }
        }

        public string PlayerName
        {
            get
            {
                return _groupName;
            }
            set
            {
                this.SetPropertyValue(ref _groupName, value);
            }
        }

        public string ArchiveName
        {
            get
            {
                return _archiveName;
            }
            set
            {
                this.SetPropertyValue(ref _archiveName, value);
            }
        }

        public float Volume
        {
            get
            {
                return _volume;
            }
            set
            {
                this.SetPropertyValue(ref _volume, value);
                this.UpdateAudible();
            }
        }

        public float ResourceVolume
        {
            get
            {
                return _resourceVolume;
            }
            set
            {
                this.SetPropertyValue(ref _resourceVolume, value);
                this.UpdateAudible();
            }
        }

        public float Priority
        {
            get
            {
                return _priority;
            }
            set
            {
                this.SetPropertyValue(ref _priority, value);
            }
        }

        public PlayKinds PlayKind
        {
            get
            {
                return _playKind;
            }
            set
            {
                this.SetPropertyValue(ref _playKind, value);
            }
        }

        public float Pitch
        {
            get { return _pitch; }
            set { this.SetPropertyValue(ref _pitch, value); }
        }

        public float Lpf
        {
            get { return _lpf; }
            set { this.SetPropertyValue(ref _lpf, value); }
        }

        public int BiquadFilterType
        {
            get { return _biquadFilterType; }
            set { this.SetPropertyValue(ref _biquadFilterType, value); }
        }

        public float BiquadFilterValue
        {
            get { return _biquadFilterValue; }
            set { this.SetPropertyValue(ref _biquadFilterValue, value); }
        }

        public int PlayerPriority
        {
            get { return _playerPriority; }
            set { this.SetPropertyValue(ref _playerPriority, value); }
        }

        public float Pan
        {
            get { return _pan; }
            set { this.SetPropertyValue(ref _pan, value); }
        }

        public float SurroundPan
        {
            get { return _surroundPan; }
            set { this.SetPropertyValue(ref _surroundPan, value); }
        }

        ///
        public void CopyFrom(PlayingSoundItemViewModel src)
        {
            this.InstanceID = src.InstanceID;

            this.IsAlive = src.IsAlive;
            this.IsFiltered = src.IsFiltered;
            this.IsVisible = src.IsVisible;
            this.IsAudible = src.IsAudible;
            this.State = src.State;
            this.SoundName = src.SoundName;
            this.PlayerName = src.PlayerName;
            this.ArchiveName = src.ArchiveName;
            this.Volume = src.Volume;
            this.ResourceVolume = src.ResourceVolume;
            this.Priority = src.Priority;
            this.PlayKind = src.PlayKind;
            this.Pitch = src.Pitch;
            this.Lpf = src.Lpf;
            this.BiquadFilterType = src.BiquadFilterType;
            this.BiquadFilterValue = src.BiquadFilterValue;
            this.PlayerPriority = src.PlayerPriority;
            this.Pan = src.Pan;
            this.SurroundPan = src.SurroundPan;
        }

        ///
        private void UpdateVisible()
        {
            this.IsVisible = _isAlive && _isFiltered;
        }

        ///
        private void UpdateAudible()
        {
            this.IsAudible = Math.Abs(this.Volume) < float.Epsilon ? false : true;
        }
    }
}
