﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Collections.Generic;
using System.Windows.Media;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    internal class LoudnessMeterValueItemViewModel : ObservableObject
    {
        public static readonly Color DefaultColor = Colors.WhiteSmoke;
        public static readonly Brush DefaultValueBrush = Brushes.WhiteSmoke;

        private string _name = string.Empty;
        private double _value = double.NaN;
        private bool _visible = true;
        private Color _color = DefaultColor;
        private Brush _valueBrush = DefaultValueBrush;
        private IEnumerable<LoudnessMeterThreshold> _thresholds;

        internal LoudnessMeterPanelViewModel Owner { get; set; }

        internal LoudnessMeterPanelViewModel.ValueSelectFunc ValueSelectFunc { get; set; }

        public string Name
        {
            get { return _name; }
            set { this.SetPropertyValue(ref _name, value); }
        }

        public double Value
        {
            get { return _value; }
            set { SetPropertyValue(ref _value, value); }
        }

        public bool IsVisible
        {
            get { return _visible; }
            set { this.SetPropertyValue(ref _visible, value); }
        }

        public Color Color
        {
            get { return _color; }
            set { this.SetPropertyValue(ref _color, value); }
        }

        public Brush ValueBrush
        {
            get { return _valueBrush; }
            set { this.SetPropertyValue(ref _valueBrush, value); }
        }

        public IEnumerable<LoudnessMeterThreshold> Thresholds
        {
            get { return _thresholds; }
            set { this.SetPropertyValue(ref _thresholds, value); }
        }

        public LoudnessMeterValueItemViewModel()
        {
        }
    }
}
