﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy;
using System.Windows.Media;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class AtkPerformanceStateValueViewModel : ObservableObject, IAtkPerformanceStateValue
    {
        private double _leftX = 0;
        private double _rightX = double.NaN;
        private double _duration = double.NaN;
        private string _text = string.Empty;

        public AtkPerformanceStateValueViewModel(PlotSpyModel.PlotStateValue model)
        {
            this.BeginTime = model.Time;
            this.EndTime = SpyTime.InvalidValue;
            this.LeftX = this.BeginTime.GetMicroSeconds();

            if (!string.IsNullOrEmpty(model.Value))
            {
                this.Value = model.Value;
                this.Text = this.Value;
                this.Color = model.Color;
            }
            else
            {
                this.Value = null;
                this.Color = Colors.Transparent;
            }
        }

        public SpyTime BeginTime { get; private set; }

        public SpyTime EndTime { get; private set; }

        public bool IsClosed
        {
            get { return !double.IsNaN(this.RightX); }
        }

        public string Value { get; protected set; }

        public string Text
        {
            get { return _text; }
            private set { this.SetPropertyValue(ref _text, value); }
        }

        public Color Color { get; protected set; }

        public double LeftX
        {
            get { return _leftX; }
            private set { this.SetPropertyValue(ref _leftX, value); }
        }

        public double RightX
        {
            get { return _rightX; }
            private set { this.SetPropertyValue(ref _rightX, value); }
        }

        public double Duration
        {
            get { return _duration; }
            private set { this.SetPropertyValue(ref _duration, value); }
        }

        public void SetEndTime(SpyTime endTime)
        {
            this.EndTime = endTime;
            this.SetRightX(endTime);
        }

        private void SetRightX(SpyTime endTime)
        {
            if (!endTime.Timestamp.IsValid)
            {
                this.RightX = double.NaN;
                this.Duration = double.NaN;
                this.Text = this.Value;
            }
            else
            {
                this.RightX = this.EndTime.Timestamp.MicroSeconds;
                this.Duration = this.RightX - this.LeftX;
                this.Text = $"{this.Value}:{this.Duration}usec";
            }
        }
    }
}
