﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    /// <summary>
    /// AtkPerformancePanel.xaml の相互作用ロジック
    /// </summary>
    public partial class AtkPerformancePanel : UserControl
    {
        private static readonly DependencyProperty MarginForPlotCanvasControllerProperty = DependencyProperty.Register(
            nameof(MarginForPlotCanvasController),
            typeof(Thickness),
            typeof(AtkPerformancePanel),
            new FrameworkPropertyMetadata(null));

        private static readonly DependencyProperty MarginForHeaderedListBoxProperty = DependencyProperty.Register(
            nameof(MarginForHeaderedListBox),
            typeof(Thickness),
            typeof(AtkPerformancePanel),
            new FrameworkPropertyMetadata(null));

        private ScrollBar _headeredListBoxVerticalScrollBar;

        public AtkPerformancePanel()
        {
            this.InitializeComponent();

            this.Loaded += (s, e) =>
            {
                var scrollViewer = (ScrollViewer)this.headeredListBox.Template.FindName("PART_ScrollViewer", this.headeredListBox);
                _headeredListBoxVerticalScrollBar = (ScrollBar)scrollViewer?.Template.FindName("PART_VerticalScrollBar", scrollViewer);

                this.UpdateMargin();
            };

            this.headeredListBox.ItemHeaderWidthChanged += (s, e) => this.UpdateMargin();
        }

        private Thickness MarginForPlotCanvasController
        {
            get { return (Thickness)GetValue(MarginForPlotCanvasControllerProperty); }
            set { SetValue(MarginForPlotCanvasControllerProperty, value); }
        }

        private Thickness MarginForHeaderedListBox
        {
            get { return (Thickness)GetValue(MarginForHeaderedListBoxProperty); }
            set { SetValue(MarginForHeaderedListBoxProperty, value); }
        }

        private void UpdateMargin()
        {
            Assertion.Operation.NotNull(_headeredListBoxVerticalScrollBar);

            var scrollBarWidth = _headeredListBoxVerticalScrollBar?.ActualWidth ?? 0d;
            var headerWidth = this.headeredListBox.ItemHeaderWidth;
            this.MarginForPlotCanvasController = new Thickness(headerWidth, 0d, scrollBarWidth, 0d);
            this.MarginForHeaderedListBox = new Thickness(-headerWidth, 0d, -scrollBarWidth, 0d);
        }
    }
}
