﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections.Specialized;
using System.Reflection;
using Microsoft.Win32;

namespace Nintendo.AudioToolkit.Views
{
    using Nintendo.Foundation.ComponentModel;
    using Nintendo.Foundation.Windows.Input;
    using Nintendo.AudioToolkit;
    using Nintendo.AudioToolkit.DataModels;
    using Nintendo.AudioToolkit.DomainModels;
    using Nintendo.AudioToolkit.Presenters;
    using Nintendo.AudioToolkit.Windows.Controls;

    public class WaveSoundPropertyPresenter : IPresenter
    {
        private WaveSoundPropertyView view = null;
        private WaveSoundPropertyViewModel viewModel = null;

        private WaveSoundClipResource waveSoundClipResource = null;

        public void Initialize()
        {
            this.view = new WaveSoundPropertyView();
        }

        /// <summary>
        /// モデルを設定します。
        /// </summary>
        /// <param name="waveSoundDM"></param>
        public void SetModel(WaveSoundClipResource model)
        {
            if (model != null)
            {
                this.waveSoundClipResource = model;
                this.viewModel = new WaveSoundPropertyViewModel(model);
                this.viewModel.ChangeFilePathCommand = new DelegateCommand(ChangeFilePath);
                this.view.DataContext = this.viewModel;
                this.view.IsEnabled = true;
            }
            else
            {
                this.waveSoundClipResource = null;
                this.view.IsEnabled = false;
                this.view.DataContext = null;
                this.viewModel = null;
            }
        }

        public Control View
        {
            get
            {
                return this.view;
            }
        }

        private void ChangeFilePath(object o)
        {
            var dialog = new OpenFileDialog();
            dialog.Title = Resources.Labels.DialogTitle_ChooseWaveFile;
            dialog.Multiselect = false;

            var filter1 = ConstConfig.WaveFileFilterExtentions.Aggregate((ts, s) => ts + "," + s);
            var filter2 = ConstConfig.WaveFileFilterExtentions.Select(s => string.Format("*{0}", s)).Aggregate((ts, s) => ts + ";" + s);

            dialog.Filter = string.Format("{0}({1})|{2}", Resources.Labels.Description_WaveFile, filter1, filter2) +
                "|" + Resources.Labels.FileFilter_All;

            bool? result = dialog.ShowDialog(null);
            if (result.HasValue == false || result.Value == false)
            {
                return;
            }

            var filePath = dialog.FileNames.FirstOrDefault();
            if (filePath != null)
            {
                this.waveSoundClipResource.Path = filePath;
            }
        }
    }
}
