﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.AudioToolkit.DataModels
{
    /// <summary>
    /// ウェーブサウンドクリップリソースのデータモデルです。
    /// </summary>
    public class WaveSoundClipResourceData
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public WaveSoundClipResourceData()
        {
            this.IsEnabled = true;
        }

        /// <summary>
        /// 有効性を取得または設定します。
        /// </summary>
        public bool IsEnabled { get; set; }

        /// <summary>
        /// 行数を取得または設定します。
        /// </summary>
        public int Row { get; set; }

        /// <summary>
        /// クリップのパスを取得または設定します。
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// クリップの位置を取得または設定します。
        /// </summary>
        public int Position { get; set; }

        /// <summary>
        /// 開始オフセット（フレーム）を取得または設定します。
        /// </summary>
        public int StartOffset { get; set; }

        /// <summary>
        /// 再生時間（フレーム）を取得または設定します。
        /// </summary>
        public int Duration { get; set; }

        /// <summary>
        /// 音量を取得または設定します。
        /// </summary>
        public float Volume { get; set; }

        /// <summary>
        /// ピッチを取得または設定します。
        /// </summary>
        public float Pitch { get; set; }

        /// <summary>
        /// パンを取得または設定します。
        /// </summary>
        public float Pan { get; set; }
    }
}
