﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <models/PreviewEffect.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
// PreviewEffectReverbHi
//---------------------------------------------------------------------------

snd::FxReverbEarlyReflectionMode PreviewEffectReverbHi::GetEarlyReflectionMode()
{
    return GetParameters().earlyMode;
}

void PreviewEffectReverbHi::SetEarlyReflectionMode(snd::FxReverbEarlyReflectionMode value)
{
    if(GetEarlyReflectionMode() == value)
    {
        return;
    }

    GetParameters().earlyMode = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetPreDelayTime()
{
    return GetParameters().preDelayTime;
}

void PreviewEffectReverbHi::SetPreDelayTime(f32 value)
{
    if(GetPreDelayTime() == value)
    {
        return;
    }

    GetParameters().preDelayTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetPreDelayTimeMax()
{
    return GetParameters().preDelayTimeMax;
}

void PreviewEffectReverbHi::SetPreDelayTimeMax(f32 value)
{
    if(GetPreDelayTimeMax() == value)
    {
        return;
    }

    if(value < GetPreDelayTime())
    {
        SetPreDelayTime(value);
    }

    GetParameters().preDelayTimeMax = value;
    SetIsDirty(true);
}

snd::FxReverbFusedMode PreviewEffectReverbHi::GetFusedMode()
{
    return GetParameters().fusedMode;
}

void PreviewEffectReverbHi::SetFusedMode(snd::FxReverbFusedMode value)
{
    if(GetFusedMode() == value)
    {
        return;
    }

    GetParameters().fusedMode = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetFusedTime()
{
    return GetParameters().fusedTime;
}

void PreviewEffectReverbHi::SetFusedTime(f32 value)
{
    if(GetFusedTime() == value)
    {
        return;
    }

    GetParameters().fusedTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetColoration()
{
    return GetParameters().coloration;
}

void PreviewEffectReverbHi::SetColoration(f32 value)
{
    if(GetColoration() == value)
    {
        return;
    }

    GetParameters().coloration = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetDamping()
{
    return GetParameters().damping;
}

void PreviewEffectReverbHi::SetDamping(f32 value)
{
    if(GetDamping() == value)
    {
        return;
    }

    GetParameters().damping = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetCrosstalk()
{
    return GetParameters().crosstalk;
}

void PreviewEffectReverbHi::SetCrosstalk(f32 value)
{
    if(GetCrosstalk() == value)
    {
        return;
    }

    GetParameters().crosstalk = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetEarlyGain()
{
    return GetParameters().earlyGain;
}

void PreviewEffectReverbHi::SetEarlyGain(f32 value)
{
    if(GetEarlyGain() == value)
    {
        return;
    }

    GetParameters().earlyGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetFusedGain()
{
    return GetParameters().fusedGain;
}

void PreviewEffectReverbHi::SetFusedGain(f32 value)
{
    if(GetFusedGain() == value)
    {
        return;
    }

    GetParameters().fusedGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbHi::GetOutGain()
{
    return GetParameters().outGain;
}

void PreviewEffectReverbHi::SetOutGain(f32 value)
{
    if(GetOutGain() == value)
    {
        return;
    }

    GetParameters().outGain = value;
    SetIsDirty(true);
}

//---------------------------------------------------------------------------
// PreviewEffectReverbStd
//---------------------------------------------------------------------------

snd::FxReverbEarlyReflectionMode PreviewEffectReverbStd::GetEarlyReflectionMode()
{
    return GetParameters().earlyMode;
}

void PreviewEffectReverbStd::SetEarlyReflectionMode(snd::FxReverbEarlyReflectionMode value)
{
    if(GetEarlyReflectionMode() == value)
    {
        return;
    }

    GetParameters().earlyMode = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetPreDelayTime()
{
    return GetParameters().preDelayTime;
}

void PreviewEffectReverbStd::SetPreDelayTime(f32 value)
{
    if(GetPreDelayTime() == value)
    {
        return;
    }

    GetParameters().preDelayTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetPreDelayTimeMax()
{
    return GetParameters().preDelayTimeMax;
}

void PreviewEffectReverbStd::SetPreDelayTimeMax(f32 value)
{
    if(GetPreDelayTimeMax() == value)
    {
        return;
    }

    if(value < GetPreDelayTime())
    {
        SetPreDelayTime(value);
    }

    GetParameters().preDelayTimeMax = value;
    SetIsDirty(true);
}

snd::FxReverbFusedMode PreviewEffectReverbStd::GetFusedMode()
{
    return GetParameters().fusedMode;
}

void PreviewEffectReverbStd::SetFusedMode(snd::FxReverbFusedMode value)
{
    if(GetFusedMode() == value)
    {
        return;
    }

    GetParameters().fusedMode = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetFusedTime()
{
    return GetParameters().fusedTime;
}

void PreviewEffectReverbStd::SetFusedTime(f32 value)
{
    if(GetFusedTime() == value)
    {
        return;
    }

    GetParameters().fusedTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetColoration()
{
    return GetParameters().coloration;
}

void PreviewEffectReverbStd::SetColoration(f32 value)
{
    if(GetColoration() == value)
    {
        return;
    }

    GetParameters().coloration = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetDamping()
{
    return GetParameters().damping;
}

void PreviewEffectReverbStd::SetDamping(f32 value)
{
    if(GetDamping() == value)
    {
        return;
    }

    GetParameters().damping = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetEarlyGain()
{
    return GetParameters().earlyGain;
}

void PreviewEffectReverbStd::SetEarlyGain(f32 value)
{
    if(GetEarlyGain() == value)
    {
        return;
    }

    GetParameters().earlyGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetFusedGain()
{
    return GetParameters().fusedGain;
}

void PreviewEffectReverbStd::SetFusedGain(f32 value)
{
    if(GetFusedGain() == value)
    {
        return;
    }

    GetParameters().fusedGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectReverbStd::GetOutGain()
{
    return GetParameters().outGain;
}

void PreviewEffectReverbStd::SetOutGain(f32 value)
{
    if(GetOutGain() == value)
    {
        return;
    }

    GetParameters().outGain = value;
    SetIsDirty(true);
}

//---------------------------------------------------------------------------
// PreviewEffectChorus
//---------------------------------------------------------------------------

f32 PreviewEffectChorus::GetDelayTime()
{
    return GetParameters().delayTime;
}

void PreviewEffectChorus::SetDelayTime(f32 value)
{
    if(GetDelayTime() == value)
    {
        return;
    }

    GetParameters().delayTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectChorus::GetDepth()
{
    return GetParameters().depth;
}

void PreviewEffectChorus::SetDepth(f32 value)
{
    if(GetDepth() == value)
    {
        return;
    }

    GetParameters().depth = value;
    SetIsDirty(true);
}

f32 PreviewEffectChorus::GetRate()
{
    return GetParameters().rate;
}

void PreviewEffectChorus::SetRate(f32 value)
{
    if(GetRate() == value)
    {
        return;
    }

    GetParameters().rate = value;
    SetIsDirty(true);
}

f32 PreviewEffectChorus::GetFeedback()
{
    return GetParameters().feedback;
}

void PreviewEffectChorus::SetFeedback(f32 value)
{
    if(GetFeedback() == value)
    {
        return;
    }

    GetParameters().feedback = value;
    SetIsDirty(true);
}

f32 PreviewEffectChorus::GetOutGain()
{
    return GetParameters().outGain;
}

void PreviewEffectChorus::SetOutGain(f32 value)
{
    if(GetOutGain() == value)
    {
        return;
    }

    GetParameters().outGain = value;
    SetIsDirty(true);
}

//---------------------------------------------------------------------------
// PreviewEffectDelay
//---------------------------------------------------------------------------

f32 PreviewEffectDelay::GetDelayTime()
{
    return GetParameters().delay;
}

void PreviewEffectDelay::SetDelayTime(f32 value)
{
    if(GetDelayTime() == value)
    {
        return;
    }

    GetParameters().delay = value;
    SetIsDirty(true);
}

f32 PreviewEffectDelay::GetMaxDelayTime()
{
    return GetParameters().maxDelay;
}

void PreviewEffectDelay::SetMaxDelayTime(f32 value)
{
    if(GetMaxDelayTime() == value)
    {
        return;
    }

    if(value < GetDelayTime())
    {
        SetDelayTime(value);
    }

    GetParameters().maxDelay = value;
    SetIsDirty(true);
}

f32 PreviewEffectDelay::GetFeedback()
{
    return GetParameters().feedback;
}

void PreviewEffectDelay::SetFeedback(f32 value)
{
    if(GetFeedback() == value)
    {
        return;
    }

    GetParameters().feedback = value;
    SetIsDirty(true);
}

f32 PreviewEffectDelay::GetOutGain()
{
    return GetParameters().outGain;
}

void PreviewEffectDelay::SetOutGain(f32 value)
{
    if(GetOutGain() == value)
    {
        return;
    }

    GetParameters().outGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectDelay::GetLpf()
{
    return GetParameters().lpf;
}

void PreviewEffectDelay::SetLpf(f32 value)
{
    if(GetLpf() == value)
    {
        return;
    }

    GetParameters().lpf = value;
    SetIsDirty(true);
}

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
//---------------------------------------------------------------------------
// PreviewEffectMultiChReverb
//---------------------------------------------------------------------------

u32 PreviewEffectMultiChReverb::GetEarlyMode()
{
    return GetParameters().earlyMode;
}

void PreviewEffectMultiChReverb::SetEarlyMode(u32 value)
{
    if(GetEarlyMode() == value)
    {
        return;
    }

    GetParameters().earlyMode = value;
    SetIsDirty(true);
}

u32 PreviewEffectMultiChReverb::GetLateMode()
{
    return GetParameters().lateMode;
}

void PreviewEffectMultiChReverb::SetLateMode(u32 value)
{
    if(GetLateMode() == value)
    {
        return;
    }

    GetParameters().lateMode = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetPreDelayTime()
{
    return GetParameters().preDelayTime;
}

void PreviewEffectMultiChReverb::SetPreDelayTime(f32 value)
{
    if(GetPreDelayTime() == value)
    {
        return;
    }

    GetParameters().preDelayTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetDecayTime()
{
    return GetParameters().decayTime;
}

void PreviewEffectMultiChReverb::SetDecayTime(f32 value)
{
    if(GetDecayTime() == value)
    {
        return;
    }

    GetParameters().decayTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetHfDecayRatio()
{
    return GetParameters().hfDecayRatio;
}

void PreviewEffectMultiChReverb::SetHfDecayRatio(f32 value)
{
    if(GetHfDecayRatio() == value)
    {
        return;
    }

    GetParameters().hfDecayRatio = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetColoration()
{
    return GetParameters().coloration;
}

void PreviewEffectMultiChReverb::SetColoration(f32 value)
{
    if(GetColoration() == value)
    {
        return;
    }

    GetParameters().coloration = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetEarlyGain()
{
    return GetParameters().earlyGain;
}

void PreviewEffectMultiChReverb::SetEarlyGain(f32 value)
{
    if(GetEarlyGain() == value)
    {
        return;
    }

    GetParameters().earlyGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetLateGain()
{
    return GetParameters().lateGain;
}

void PreviewEffectMultiChReverb::SetLateGain(f32 value)
{
    if(GetLateGain() == value)
    {
        return;
    }

    GetParameters().lateGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChReverb::GetReverbGain()
{
    return GetParameters().reverbGain;
}

void PreviewEffectMultiChReverb::SetReverbGain(f32 value)
{
    if(GetReverbGain() == value)
    {
        return;
    }

    GetParameters().reverbGain = value;
    SetIsDirty(true);
}

void PreviewEffectMultiChReverb::SetChannelMode(FxBase::ChannelMode mode)
{
    FxMultiChReverb* effect = GetDerivedEffect();

    effect->SetChannelMode(mode);
}

//---------------------------------------------------------------------------
// PreviewEffectMultiChChorus
//---------------------------------------------------------------------------

f32 PreviewEffectMultiChChorus::GetDelayTime()
{
    return GetParameters().delayTime;
}

void PreviewEffectMultiChChorus::SetDelayTime(f32 value)
{
    if(GetDelayTime() == value)
    {
        return;
    }

    GetParameters().delayTime = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChChorus::GetDepth()
{
    return GetParameters().depth;
}

void PreviewEffectMultiChChorus::SetDepth(f32 value)
{
    if(GetDepth() == value)
    {
        return;
    }

    GetParameters().depth = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChChorus::GetRate()
{
    return GetParameters().rate;
}

void PreviewEffectMultiChChorus::SetRate(f32 value)
{
    if(GetRate() == value)
    {
        return;
    }

    GetParameters().rate = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChChorus::GetFeedback()
{
    return GetParameters().feedback;
}

void PreviewEffectMultiChChorus::SetFeedback(f32 value)
{
    if(GetFeedback() == value)
    {
        return;
    }

    GetParameters().feedback = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChChorus::GetOutGain()
{
    return GetParameters().outGain;
}

void PreviewEffectMultiChChorus::SetOutGain(f32 value)
{
    if(GetOutGain() == value)
    {
        return;
    }

    GetParameters().outGain = value;
    SetIsDirty(true);
}

void PreviewEffectMultiChChorus::SetChannelMode(FxBase::ChannelMode mode)
{
    FxMultiChChorus* effect = GetDerivedEffect();

    effect->SetChannelMode(mode);
}

//---------------------------------------------------------------------------
// PreviewEffectMultiChDelay
//---------------------------------------------------------------------------

f32 PreviewEffectMultiChDelay::GetDelay()
{
    return GetParameters().delay;
}

void PreviewEffectMultiChDelay::SetDelay(f32 value)
{
    if(GetDelay() == value)
    {
        return;
    }

    GetParameters().delay = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChDelay::GetFeedback()
{
    return GetParameters().feedback;
}

void PreviewEffectMultiChDelay::SetFeedback(f32 value)
{
    if(GetFeedback() == value)
    {
        return;
    }

    GetParameters().feedback = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChDelay::GetOutGain()
{
    return GetParameters().outGain;
}

void PreviewEffectMultiChDelay::SetOutGain(f32 value)
{
    if(GetOutGain() == value)
    {
        return;
    }

    GetParameters().outGain = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChDelay::GetChannelSpread()
{
    return GetParameters().channelSpread;
}

void PreviewEffectMultiChDelay::SetChannelSpread(f32 value)
{
    if(GetChannelSpread() == value)
    {
        return;
    }

    GetParameters().channelSpread = value;
    SetIsDirty(true);
}

f32 PreviewEffectMultiChDelay::GetLpf()
{
    return GetParameters().lpf;
}

void PreviewEffectMultiChDelay::SetLpf(f32 value)
{
    if(GetLpf() == value)
    {
        return;
    }

    GetParameters().lpf = value;
    SetIsDirty(true);
}

void PreviewEffectMultiChDelay::SetChannelMode(FxBase::ChannelMode mode)
{
    FxMultiChDelay* effect = GetDerivedEffect();

    effect->SetChannelMode(mode);
}
#endif

} // nw::snd
} // nw
