﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"
#include "mcs/handler/PreviewPlayerParameter.h"
#include "../../Application.h"

namespace nw    {
namespace snd   {


PreviewPlayerParameter::PreviewPlayerParameter()
: INIT_PROPERTY_VALUE( Volume ),
  INIT_PROPERTY_VALUE( Pitch ),
  INIT_PROPERTY_VALUE( Pan ),
  INIT_PROPERTY_VALUE( SurroundPan ),
  INIT_PROPERTY_VALUE( LpfFrequency ),
  INIT_PROPERTY_VALUE( BiquadType ),
  INIT_PROPERTY_VALUE( BiquadValue ),
  INIT_PROPERTY_VALUE( StartOffsetTime ),
  INIT_PROPERTY_VALUE( MainOutEnabled ),
  INIT_PROPERTY_VALUE( Remote0OutEnabled ),
  INIT_PROPERTY_VALUE( Remote1OutEnabled ),
  INIT_PROPERTY_VALUE( Remote2OutEnabled ),
  INIT_PROPERTY_VALUE( Remote3OutEnabled ),
  INIT_PROPERTY_VALUE( MainOutVolume ),
  INIT_PROPERTY_VALUE( Remote0OutVolume ),
  INIT_PROPERTY_VALUE( Remote1OutVolume ),
  INIT_PROPERTY_VALUE( Remote2OutVolume ),
  INIT_PROPERTY_VALUE( Remote3OutVolume ),
  INIT_PROPERTY_VALUE( MainSend ),
  INIT_PROPERTY_VALUE( EffectAuxASend ),
  INIT_PROPERTY_VALUE( EffectAuxBSend ),
  INIT_PROPERTY_VALUE( EffectAuxCSend ),
  INIT_PROPERTY_VALUE( FadeInFrames ),
  INIT_PROPERTY_VALUE( FadeOutFrames ),
  INIT_PROPERTY_VALUE( PauseFadeFrames ),
  m_bParameterChangedEventLocked( false ),
  m_bParameterDirty( false )
{
}

void PreviewPlayerParameter::LockParameterChangedEvent()
{
    if( m_bParameterChangedEventLocked ) return;

    m_bParameterChangedEventLocked = true;
}

void PreviewPlayerParameter::UnlockParameterChangedEvent()
{
    m_bParameterChangedEventLocked = false;

    if( m_bParameterDirty ) {
        OnParameterChanged();
        m_bParameterDirty = false;
    }
}

void PreviewPlayerParameter::OnInternalParameterChanged()
{
    m_bParameterDirty = true;

    if( m_bParameterChangedEventLocked ) return;

    OnParameterChanged();
    m_bParameterDirty = false;
}


} // namespace snd
} // namespace nw
