﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/MultiChReverbParameterListView.h>

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)

namespace {

enum EarlyMode
{
    EARLY_MODE_SMALL_ROOM = 0,
    EARLY_MODE_LARGE_ROOM,
    EARLY_MODE_HALL,
    EARLY_MODE_CAVERN,
    EARLY_MODE_NO_EARLY_REFLECTION,
    EARLY_MODE_NUM
};

enum LateMode
{
    LATE_MODE_ROOM = 0,
    LATE_MODE_HALL,
    LATE_MODE_METAL_CORRIDOR,
    LATE_MODE_CAVERN,
    LATE_MODE_MAXIMUM_REVERB_DELAY,
    LATE_MODE_NUM
};

static const u32 s_EarlyModeValues[] =
{
    EARLY_MODE_SMALL_ROOM,
    EARLY_MODE_LARGE_ROOM,
    EARLY_MODE_HALL,
    EARLY_MODE_CAVERN,
    EARLY_MODE_NO_EARLY_REFLECTION
};

static const u32 s_LateModeValues[] =
{
    LATE_MODE_ROOM,
    LATE_MODE_HALL,
    LATE_MODE_METAL_CORRIDOR,
    LATE_MODE_CAVERN,
    LATE_MODE_MAXIMUM_REVERB_DELAY
};

static void PrintEarlyMode(char* pText, u32 bufferLength, u32 value)
{
    const char* pValueText = "";

    switch(value)
    {
    case EARLY_MODE_SMALL_ROOM:
        pValueText = "SmallRoom";
        break;
    case EARLY_MODE_LARGE_ROOM:
        pValueText = "LargeRoom";
        break;
    case EARLY_MODE_HALL:
        pValueText = "Hall";
        break;
    case EARLY_MODE_CAVERN:
        pValueText = "Cavern";
        break;
    case EARLY_MODE_NO_EARLY_REFLECTION:
        pValueText = "None";
        break;
    }

    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%s", pValueText);
}

static void PrintLateMode(char* pText, u32 bufferLength, u32 value)
{
    const char* pValueText = "";

    switch(value)
    {
    case LATE_MODE_ROOM:
        pValueText = "Room";
        break;
    case LATE_MODE_HALL:
        pValueText = "Hall";
        break;
    case LATE_MODE_METAL_CORRIDOR:
        pValueText = "MetalCorridor";
        break;
    case LATE_MODE_CAVERN:
        pValueText = "Cavern";
        break;
    case LATE_MODE_MAXIMUM_REVERB_DELAY:
        pValueText = "Maximum";
        break;
    }

    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%s", pValueText);
}

static u32 GetEarlyMode(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetEarlyMode();
}

static u32 GetLateMode(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetLateMode();
}

static f32 GetPreDelayTime(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetPreDelayTime();
}

static f32 GetDecayTime(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetDecayTime();
}

static f32 GetHfDecayRatio(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetHfDecayRatio();
}

static f32 GetColoration(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetColoration();
}

static f32 GetEarlyGain(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetEarlyGain();
}

static f32 GetLateGain(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetLateGain();
}

static f32 GetReverbGain(nw::snd::PreviewEffectMultiChReverb* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetReverbGain();
}

static void SetEarlyMode(nw::snd::PreviewEffectMultiChReverb* pParameter, u32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetEarlyMode(value);
}

static void SetLateMode(nw::snd::PreviewEffectMultiChReverb* pParameter, u32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetLateMode(value);
}

static void SetPreDelayTime(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetPreDelayTime(value);
}

static void SetDecayTime(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetDecayTime(value);
}

static void SetHfDecayRatio(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetHfDecayRatio(value);
}

static void SetColoration(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetColoration(value);
}

static void SetEarlyGain(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetEarlyGain(value);
}

static void SetLateGain(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetLateGain(value);
}

static void SetReverbGain(nw::snd::PreviewEffectMultiChReverb* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetReverbGain(value);
}

    /*
static void PrintU32Value(char* pText, u32 bufferLength, u32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%d", value);
}
    */

static void PrintF32Value(char* pText, u32 bufferLength, f32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%7.2f", value);
}

}

namespace nw {
namespace snd {

MultiChReverbParameterListView::MultiChReverbParameterListView()
: m_EarlyModeControl(EARLY_MODE_SMALL_ROOM)
, m_LateModeControl(LATE_MODE_ROOM)
{
    m_EarlyModeControl.Initialize(
        s_EarlyModeValues,
        EARLY_MODE_NUM,
        GetEarlyMode,
        SetEarlyMode,
        PrintEarlyMode);
    m_EarlyModeControl.SetLabelText("EarlyMode:");

    m_LateModeControl.Initialize(
        s_LateModeValues,
        LATE_MODE_NUM,
        GetLateMode,
        SetLateMode,
        PrintLateMode);
    m_LateModeControl.SetLabelText("LateMode:");

    m_PreDelayTimeControl.Initialize(GetPreDelayTime, SetPreDelayTime, PrintF32Value);
    m_PreDelayTimeControl.SetLabelText("PreDelayTime:");
    m_PreDelayTimeControl.SetMinimumValue(0.0f);
    m_PreDelayTimeControl.SetMaximumValue(100.0f);
    m_PreDelayTimeControl.SetDefaultValue(0.02f);
    m_PreDelayTimeControl.SetValueChange(0.01f);
    m_PreDelayTimeControl.SetValueLargeChange(0.1f);

    m_DecayTimeControl.Initialize(GetDecayTime, SetDecayTime, PrintF32Value);
    m_DecayTimeControl.SetLabelText("DecayTime:");
    m_DecayTimeControl.SetMinimumValue(0.1f);
    m_DecayTimeControl.SetMaximumValue(20.0f);
    m_DecayTimeControl.SetDefaultValue(3.0f);
    m_DecayTimeControl.SetValueChange(0.1f);
    m_DecayTimeControl.SetValueLargeChange(1.0f);

    m_HfDecayRatioControl.Initialize(GetHfDecayRatio, SetHfDecayRatio, PrintF32Value);
    m_HfDecayRatioControl.SetLabelText("HfDecayRatio:");
    m_HfDecayRatioControl.SetMinimumValue(0.1f);
    m_HfDecayRatioControl.SetMaximumValue(1.0f);
    m_HfDecayRatioControl.SetDefaultValue(0.4f);
    m_HfDecayRatioControl.SetValueChange(0.1f);
    m_HfDecayRatioControl.SetValueLargeChange(1.0f);

    m_ColorationControl.Initialize(GetColoration, SetColoration, PrintF32Value);
    m_ColorationControl.SetLabelText("Coloration:");
    m_ColorationControl.SetMinimumValue(0.0f);
    m_ColorationControl.SetMaximumValue(1.0f);
    m_ColorationControl.SetDefaultValue(0.6f);
    m_ColorationControl.SetValueChange(0.01f);
    m_ColorationControl.SetValueLargeChange(0.1f);

    m_EarlyGainControl.Initialize(GetEarlyGain, SetEarlyGain, PrintF32Value);
    m_EarlyGainControl.SetLabelText("EarlyGain:");
    m_EarlyGainControl.SetMinimumValue(0.0f);
    m_EarlyGainControl.SetMaximumValue(1.0f);
    m_EarlyGainControl.SetDefaultValue(0.0f);
    m_EarlyGainControl.SetValueChange(0.01f);
    m_EarlyGainControl.SetValueLargeChange(0.1f);

    m_LateGainControl.Initialize(GetLateGain, SetLateGain, PrintF32Value);
    m_LateGainControl.SetLabelText("LateGain:");
    m_LateGainControl.SetMinimumValue(0.0f);
    m_LateGainControl.SetMaximumValue(1.0f);
    m_LateGainControl.SetDefaultValue(1.0f);
    m_LateGainControl.SetValueChange(0.01f);
    m_LateGainControl.SetValueLargeChange(0.1f);

    m_ReverbGainControl.Initialize(GetReverbGain, SetReverbGain, PrintF32Value);
    m_ReverbGainControl.SetLabelText("ReverbGain:");
    m_ReverbGainControl.SetMinimumValue(0.0f);
    m_ReverbGainControl.SetMaximumValue(1.0f);
    m_ReverbGainControl.SetDefaultValue(1.0f);
    m_ReverbGainControl.SetValueChange(0.01f);
    m_ReverbGainControl.SetValueLargeChange(0.1f);

    AddItem(m_EarlyModeControl);
    AddItem(m_LateModeControl);
    AddItem(m_PreDelayTimeControl);
    AddItem(m_DecayTimeControl);
    AddItem(m_HfDecayRatioControl);
    AddItem(m_ColorationControl);
    AddItem(m_EarlyGainControl);
    AddItem(m_LateGainControl);
    AddItem(m_ReverbGainControl);
}

} // snd
} // nw

#endif
