﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/MultiChDelayParameterListView.h>

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)

namespace {

static f32 GetDelay(nw::snd::PreviewEffectMultiChDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetDelay();
}

static f32 GetFeedback(nw::snd::PreviewEffectMultiChDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetFeedback();
}

static f32 GetChannelSpread(nw::snd::PreviewEffectMultiChDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetChannelSpread();
}

static f32 GetOutGain(nw::snd::PreviewEffectMultiChDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetOutGain();
}

static f32 GetLpf(nw::snd::PreviewEffectMultiChDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetLpf();
}

static void SetDelay(nw::snd::PreviewEffectMultiChDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetDelay(value);
}

static void SetFeedback(nw::snd::PreviewEffectMultiChDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetFeedback(value);
}

static void SetOutGain(nw::snd::PreviewEffectMultiChDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetOutGain(value);
}

static void SetChannelSpread(nw::snd::PreviewEffectMultiChDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetChannelSpread(value);
}

static void SetLpf(nw::snd::PreviewEffectMultiChDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetLpf(value);
}

static void PrintF32Value(char* pText, u32 bufferLength, f32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%7.2f", value);
}

}

namespace nw {
namespace snd {

MultiChDelayParameterListView::MultiChDelayParameterListView()
{
    m_DelayControl.Initialize(GetDelay, SetDelay, PrintF32Value);
    m_DelayControl.SetLabelText("Delay:");
    m_DelayControl.SetMinimumValue(0.0f);
    m_DelayControl.SetMaximumValue(2000.f);
    m_DelayControl.SetDefaultValue(160.f);
    m_DelayControl.SetValueChange(1.0f);
    m_DelayControl.SetValueLargeChange(10.f);

    m_FeedbackControl.Initialize(GetFeedback, SetFeedback, PrintF32Value);
    m_FeedbackControl.SetLabelText("Feedback:");
    m_FeedbackControl.SetMinimumValue(0.1f);
    m_FeedbackControl.SetMaximumValue(1.0f);
    m_FeedbackControl.SetDefaultValue(0.4f);
    m_FeedbackControl.SetValueChange(0.01f);
    m_FeedbackControl.SetValueLargeChange(0.1f);

    m_OutGainControl.Initialize(GetOutGain, SetOutGain, PrintF32Value);
    m_OutGainControl.SetLabelText("OutGain:");
    m_OutGainControl.SetMinimumValue(0.1f);
    m_OutGainControl.SetMaximumValue(1.0f);
    m_OutGainControl.SetDefaultValue(1.0f);
    m_OutGainControl.SetValueChange(0.01f);
    m_OutGainControl.SetValueLargeChange(0.1f);

    m_ChannelSpreadControl.Initialize(GetChannelSpread, SetChannelSpread, PrintF32Value);
    m_ChannelSpreadControl.SetLabelText("ChannelSpread:");
    m_ChannelSpreadControl.SetMinimumValue(0.1f);
    m_ChannelSpreadControl.SetMaximumValue(1.0f);
    m_ChannelSpreadControl.SetDefaultValue(0.4f);
    m_ChannelSpreadControl.SetValueChange(0.01f);
    m_ChannelSpreadControl.SetValueLargeChange(0.1f);

    m_LpfControl.Initialize(GetLpf, SetLpf, PrintF32Value);
    m_LpfControl.SetLabelText("Lpf:");
    m_LpfControl.SetMinimumValue(0.1f);
    m_LpfControl.SetMaximumValue(1.0f);
    m_LpfControl.SetDefaultValue(1.0f);
    m_LpfControl.SetValueChange(0.01f);
    m_LpfControl.SetValueLargeChange(0.1f);

    AddItem(m_DelayControl);
    AddItem(m_FeedbackControl);
    AddItem(m_OutGainControl);
    AddItem(m_ChannelSpreadControl);
    AddItem(m_LpfControl);
}

} // snd
} // nw

#endif
