﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Memory.h>
#include <resources/IResourceProvider.h>

#if defined(NW_PLATFORM_CAFE)
#include <cafe/fs.h>
#endif

namespace nw {
namespace snd {

namespace edit {
class SoundEditSession;
}

class PreviewSoundArchive;
class PreviewEffectManager;

class GlobalResourceProvider : public IResourceProvider
{
public:
    /* ctor */ GlobalResourceProvider();
    /* dtor */ virtual ~GlobalResourceProvider() { }

public:
    void SetAllocator(ut::IAllocator* value)
    {
        m_Allocator = value;
    }

#if defined(NW_PLATFORM_CAFE)
    void SetFsClient(FSClient* value)
    {
        m_FsClient = value;
    }

    void SetFsCmdBlock(FSCmdBlock* value)
    {
        m_FsCmdBlock = value;
    }

    void SetHfioVolume(const char* value)
    {
        m_HfioVolume = value;
    }
#endif

    void SetPreviewSoundArchive(PreviewSoundArchive* value)
    {
        m_pPreviewSoundArchive = value;
    }

    void SetPreviewEffectManager(PreviewEffectManager* value)
    {
        m_pPreviewEffectManager = value;
    }

    void SetPreviewEffectManagerDrc(PreviewEffectManager* value)
    {
        m_pPreviewEffectManagerDrc = value;
    }

    void SetSoundEditSession(edit::SoundEditSession* value)
    {
        m_pSoundEditSession = value;
    }

    virtual void* GetResource(const char* pPath) const;
    virtual bool TryGetResource(const char* pPath, void** pResource) const;

    virtual const void* GetConstResource(const char* pPath) const;
    virtual bool TryGetConstResource(const char* pPath, const void** pResource) const;

private:
    ut::IAllocator * m_Allocator;

#if defined(NW_PLATFORM_CAFE)
    FSClient*   m_FsClient;
    FSCmdBlock* m_FsCmdBlock;
    const char* m_HfioVolume;
#endif

    PreviewSoundArchive*    m_pPreviewSoundArchive;
    PreviewEffectManager*   m_pPreviewEffectManager;
    PreviewEffectManager*   m_pPreviewEffectManagerDrc;
    edit::SoundEditSession* m_pSoundEditSession;
};

} // snd
} // nw
