﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <panels/EffectPanel.h>
#include <controls/Lamp.h>

namespace nw {
namespace snd {

class IResourceProvider;

class EffectCafePanel : public EffectPanel
{
public:
    EffectCafePanel();
    virtual ~EffectCafePanel();

    void Initialize(IResourceProvider& resourceProvider);
    void Finalize();

public:
    /* override */ void SetDevice(u32 deviceType);
    /* override */ PreviewEffectManager* CurrentPreviewEffectManager();
    /* override */ nw::snd::PreviewEffectType* GetDefaultPreviewEffectTypes();
    /* override */ u32 GetPreviewEffectCount();

protected:
    /* override */ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    /* override */ void InitializeLampBar(nw::internal::dw::StackPanel& lampBar);
    /* override */ void OnEffectApplied();

private:
    bool IsMainOutput();

private:
    nw::internal::dw::FixedUIElementList<2> m_LampBarContents;
    Lamp m_MainLamp;
    Lamp m_DrcLamp;

    PreviewEffectManager* m_pEffectManager;
    PreviewEffectManager* m_pEffectManagerDrc;
    PreviewEffectManager::AppliedEventHandler m_EffectAppliedEventHandler;
    PreviewEffectManager::AppliedEventHandler m_EffectDrcAppliedEventHandler;

#if defined(NW_DEBUG)
public:
    /* override */ const char* ToString() const
    {
        return "EffectCafePanel";
    }
#endif
};

} // snd
} // nw
