﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/dw/control/dw_Separator.h>
#include <models/PreviewEffectManager.h>
#include <controls/AuxBusControl.h>
#include <controls/EffectParametersView.h>
#include <controls/Lamp.h>

namespace nw {
namespace snd {

class PreviewEffectSet;

class EffectPanel : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_EFFECT_BUS_COUNT = 8;
    static const s32 INVALID_INDEX = -1;

    enum CommandState
    {
        CommandState_Idle,
        CommandState_1st,
        CommandState_2nd,
        CommandState_3rd,
        CommandState_4th,
        CommandState_5th,
        CommandState_6th,
        CommandState_7th,
        CommandState_Accepted
    };

public:
    EffectPanel();
    virtual ~EffectPanel();

public:
    void InitializeContent();
    void InitializeModel();

    s32 GetSelectedAuxBusIndex();
    s32 GetSelectedEffectIndex();
    void SetSelectedEffectIndex(s32 busIndex, s32 effectIndex);
    void SelectEffect(s32 busIndex, s32 effectIndex);

public:
    virtual void SetDevice(u32 deviceType) = 0;
    virtual PreviewEffectManager* CurrentPreviewEffectManager() = 0;
    virtual nw::snd::PreviewEffectType* GetDefaultPreviewEffectTypes() = 0;
    virtual u32 GetPreviewEffectCount() = 0;

protected:
    /* override */ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    void CheckCommand(const nw::dev::Pad& pad);

protected:
    void SetAssignedMemory(const char* text);

protected:
    virtual void InitializeLampBar(nw::internal::dw::StackPanel& lampBar) = 0;
    virtual void OnEffectApplied() = 0;

private:
    s32 GetAuxBusCount() const;
    void SetAuxBusCount(s32 value);

    PreviewEffectSet* GetSelectedEffectSet();

    s32 GetSelectedPreviewEffectTypeIndex();
    void SetSelectedPreviewEffectTypeIndex(s32 index);
    snd::PreviewEffectType GetPreviewEffectType(s32 index);

    void CalculateEffectCount();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<5> m_Container;

    nw::internal::dw::FixedStackPanel<MAX_EFFECT_BUS_COUNT> m_AuxBusPanel;
    AuxBusControl m_AuxBusControls[MAX_EFFECT_BUS_COUNT];
    EffectParametersView m_EffectParametersView;

    nw::internal::dw::FixedStackPanel<2> m_AssignedMemoryPanel;
    nw::internal::dw::FixedLabel<16> m_AssignedMemoryLabel;
    nw::internal::dw::FixedLabel<16> m_AssignedMemoryValueLabel;

    nw::internal::dw::Separator m_Separator;

    nw::internal::dw::StackPanel m_LampBar;

    s32 m_SelectedAuxBusIndex;
    s32 m_SelectedEffectIndex;

    PreviewEffectType* m_pPreviewEffectTypes;
    s32 m_PreviewEffectCount;

    CommandState m_CommandState;

#if defined(NW_DEBUG)
public:
    /* override */ const char* ToString() const
    {
        return "EffectPanel";
    }
#endif
};

} // snd
} // nw
